/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.util.Config;
import xiroc.dungeoncrawl.util.EventManager;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

@Mod(value="dungeoncrawl")
public class DungeonCrawl {
    public static final String MODID = "dungeoncrawl";
    public static final String NAME = "Dungeon Crawl";
    public static final String VERSION = "1.3.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static List<String> BIOME_BLACKLIST = Lists.newArrayList((Object[])new String[]{"minecraft:the_end", "minecraft:nether", "minecraft:small_end_islands", "minecraft:end_midlands", "minecraft:end_highlands", "minecraft:end_barrens", "minecraft:the_void"});
    public static List<String> BIOME_OVERWORLD_BLACKLIST = Lists.newArrayList((Object[])new String[]{"minecraft:ocean", "minecraft:deep_ocean", "minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:cold_ocean", "minecraft:deep_warm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_frozen_ocean"});

    public DungeonCrawl() {
        LOGGER.info("Here we go!");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventManager());
        Feature.field_202300_at.put((Object)"DCDungeon".toLowerCase(Locale.ROOT), Dungeon.DUNGEON_FEATURE);
        DungeonSegmentModelBlock.load();
        IBlockPlacementHandler.load();
        BlockRegistry.load();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CONFIG);
        Config.load(FMLPaths.CONFIGDIR.get().resolve("dungeon_crawl.toml"));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Client Setup");
    }

    public static String getDate() {
        return new SimpleDateFormat().format(new Date());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        DungeonSegmentModelRegistry.load((IResourceManager)((ServerWorld)event.getWorld()).func_73046_m().func_195570_aG());
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MODID, path);
    }
}

