/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModel;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.RotationHelper;

public class DungeonPieces {
    public static final CompoundNBT DEFAULT_NBT = DungeonPieces.getDefaultNBT();
    public static final CompoundNBT DEFAULT_LARGE_NBT = DungeonPieces.getDefaultLargeNBT();
    private static final Set<Block> BLOCKS_NEEDING_POSTPROCESSING = ImmutableSet.builder().add((Object)Blocks.field_150386_bk).add((Object)Blocks.field_150478_aa).add((Object)Blocks.field_196591_bQ).add((Object)Blocks.field_180407_aO).add((Object)Blocks.field_180408_aP).add((Object)Blocks.field_180406_aS).add((Object)Blocks.field_180405_aT).add((Object)Blocks.field_180404_aQ).add((Object)Blocks.field_180403_aR).add((Object)Blocks.field_150468_ap).add((Object)Blocks.field_150411_aY).add((Object)Blocks.field_150390_bg).add((Object)Blocks.field_196659_cl).add((Object)Blocks.field_150387_bl).add((Object)Blocks.field_150473_bD).build();

    public static CompoundNBT getDefaultNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("north", false);
        nbt.func_74757_a("east", false);
        nbt.func_74757_a("south", false);
        nbt.func_74757_a("west", false);
        nbt.func_74757_a("up", false);
        nbt.func_74757_a("down", false);
        nbt.func_74768_a("connectedSides", 0);
        nbt.func_74768_a("posX", -1);
        nbt.func_74768_a("posZ", -1);
        nbt.func_74768_a("theme", 0);
        nbt.func_74768_a("stage", -1);
        nbt.func_74768_a("rotation", 0);
        return nbt;
    }

    public static CompoundNBT getDefaultLargeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("north1", false);
        nbt.func_74757_a("north2", false);
        nbt.func_74757_a("east1", false);
        nbt.func_74757_a("east2", false);
        nbt.func_74757_a("south1", false);
        nbt.func_74757_a("south2", false);
        nbt.func_74757_a("west1", false);
        nbt.func_74757_a("west2", false);
        nbt.func_74768_a("connectedSides", 0);
        nbt.func_74768_a("posX", -1);
        nbt.func_74768_a("posZ", -1);
        nbt.func_74768_a("theme", 0);
        nbt.func_74768_a("rotation", 0);
        return nbt;
    }

    public static void addWalls(DungeonPiece piece, IWorld world, Theme theme) {
        int z;
        int y;
        int x;
        if (!piece.sides[0]) {
            for (x = 2; x < 6; ++x) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(theme.wall.get(), world, piece.x + x, piece.y + y, piece.z, 0);
                }
            }
        }
        if (!piece.sides[1]) {
            for (z = 2; z < 6; ++z) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(theme.wall.get(), world, piece.x + 7, piece.y + y, piece.z + z, 0);
                }
            }
        }
        if (!piece.sides[2]) {
            for (x = 2; x < 6; ++x) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(theme.wall.get(), world, piece.x + x, piece.y + y, piece.z + 7, 0);
                }
            }
        }
        if (!piece.sides[3]) {
            for (z = 2; z < 6; ++z) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(theme.wall.get(), world, piece.x, piece.y + y, piece.z + z, 0);
                }
            }
        }
    }

    public static int getGroudHeight(IWorld world, int x, int z) {
        for (int y = 255; y > 0; --y) {
            if (!world.func_180495_p(new BlockPos(x, y, z)).func_200132_m()) continue;
            return y;
        }
        return 0;
    }

    public static abstract class DungeonPiece
    extends StructurePiece {
        public Rotation field_186169_c;
        public int connectedSides;
        public int posX;
        public int posZ;
        public int theme;
        public int x;
        public int y;
        public int z;
        public int stage;
        public boolean[] sides = new boolean[6];

        public DungeonPiece(IStructurePieceType p_i51343_1_, CompoundNBT p_i51343_2_) {
            super(p_i51343_1_, p_i51343_2_);
            this.sides[0] = p_i51343_2_.func_74767_n("north");
            this.sides[1] = p_i51343_2_.func_74767_n("east");
            this.sides[2] = p_i51343_2_.func_74767_n("south");
            this.sides[3] = p_i51343_2_.func_74767_n("west");
            this.sides[4] = p_i51343_2_.func_74767_n("up");
            this.sides[5] = p_i51343_2_.func_74767_n("down");
            this.connectedSides = p_i51343_2_.func_74762_e("connectedSides");
            this.posX = p_i51343_2_.func_74762_e("posX");
            this.posZ = p_i51343_2_.func_74762_e("posZ");
            this.x = p_i51343_2_.func_74762_e("x");
            this.y = p_i51343_2_.func_74762_e("y");
            this.z = p_i51343_2_.func_74762_e("z");
            this.theme = p_i51343_2_.func_74762_e("theme");
            this.stage = p_i51343_2_.func_74762_e("stage");
            this.field_186169_c = RotationHelper.getRotationFromInt(p_i51343_2_.func_74762_e("rotation"));
            this.field_74887_e = new MutableBoundingBox(this.x, this.y, this.z, this.x + 7, this.y + 7, this.z + 7);
        }

        public abstract int getType();

        public void openSide(Direction side) {
            switch (side) {
                case NORTH: {
                    if (this.sides[0]) {
                        return;
                    }
                    this.sides[0] = true;
                    ++this.connectedSides;
                    return;
                }
                case EAST: {
                    if (this.sides[1]) {
                        return;
                    }
                    this.sides[1] = true;
                    ++this.connectedSides;
                    return;
                }
                case SOUTH: {
                    if (this.sides[2]) {
                        return;
                    }
                    this.sides[2] = true;
                    ++this.connectedSides;
                    return;
                }
                case WEST: {
                    if (this.sides[3]) {
                        return;
                    }
                    this.sides[3] = true;
                    ++this.connectedSides;
                    return;
                }
                case UP: {
                    if (this.sides[4]) {
                        return;
                    }
                    this.sides[4] = true;
                    ++this.connectedSides;
                    return;
                }
                case DOWN: {
                    if (this.sides[5]) {
                        return;
                    }
                    this.sides[5] = true;
                    ++this.connectedSides;
                    return;
                }
            }
            DungeonCrawl.LOGGER.warn("Failed to open a segment side: Unknown side " + side);
        }

        public void setRotation(Rotation rotation) {
            this.field_186169_c = rotation;
        }

        public Rotation func_214809_Y_() {
            return this.field_186169_c;
        }

        public void setPosition(int x, int z) {
            this.posX = x;
            this.posZ = z;
        }

        public void setRealPosition(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.field_74887_e = new MutableBoundingBox(x, y, z, x + 7, y + 7, z + 7);
        }

        public void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74757_a("north", this.sides[0]);
            tagCompound.func_74757_a("east", this.sides[1]);
            tagCompound.func_74757_a("south", this.sides[2]);
            tagCompound.func_74757_a("west", this.sides[3]);
            tagCompound.func_74757_a("up", this.sides[4]);
            tagCompound.func_74757_a("down", this.sides[5]);
            tagCompound.func_74768_a("connectedSides", this.connectedSides);
            tagCompound.func_74768_a("posX", this.posX);
            tagCompound.func_74768_a("posZ", this.posZ);
            tagCompound.func_74768_a("x", this.x);
            tagCompound.func_74768_a("y", this.y);
            tagCompound.func_74768_a("z", this.z);
            tagCompound.func_74768_a("stage", this.stage);
            tagCompound.func_74768_a("theme", this.theme);
            tagCompound.func_74768_a("rotation", RotationHelper.getIntFromRotation(this.field_186169_c));
        }

        public void setBlockState(BlockState state, IWorld world, int x, int y, int z, int lootLevel) {
            BlockPos pos = new BlockPos(x, y, z);
            if (state == null) {
                return;
            }
            IBlockPlacementHandler.getHandler(state.func_177230_c()).setupBlock(world, state, pos, world.func_201674_k(), lootLevel);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
                world.func_217349_x(pos).func_201594_d(pos);
            }
        }

        public void build(DungeonSegmentModel model, IWorld world, BlockPos pos, Theme theme, int lootLevel) {
            int fwb = 0;
            int td = 0;
            for (int x = 0; x < model.width; ++x) {
                for (int y = 0; y < model.height; ++y) {
                    for (int z = 0; z < model.length; ++z) {
                        BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : (model.model[x][y][z].type == DungeonSegmentModelBlockType.FWB_PLACEHOLDER ? DungeonSegmentModelBlock.getBlockState(model.fourWayBlocks[fwb++], theme, world.func_201674_k()) : (model.model[x][y][z].type == DungeonSegmentModelBlockType.TRAPDOOR ? DungeonSegmentModelBlock.getBlockState(model.trapDoors[td++], theme, world.func_201674_k()) : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k())));
                        if (state == null) continue;
                        this.setBlockState(state, world, pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z, lootLevel);
                    }
                }
            }
        }

        public void buildRotated(DungeonSegmentModel model, IWorld world, BlockPos pos, Theme theme, int lootLevel, Rotation rotation) {
            int fwb = 0;
            int td = 0;
            switch (rotation) {
                case CLOCKWISE_90: {
                    for (int x = 0; x < model.width; ++x) {
                        for (int y = 0; y < model.height; ++y) {
                            for (int z = 0; z < model.length; ++z) {
                                BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : (model.model[x][y][z].type == DungeonSegmentModelBlockType.FWB_PLACEHOLDER ? DungeonSegmentModelBlock.getBlockState(model.fourWayBlocks[fwb++], theme, world.func_201674_k(), Rotation.CLOCKWISE_90) : (model.model[x][y][z].type == DungeonSegmentModelBlockType.TRAPDOOR ? DungeonSegmentModelBlock.getBlockState(model.trapDoors[td++], theme, world.func_201674_k(), Rotation.CLOCKWISE_90) : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), Rotation.CLOCKWISE_90)));
                                if (state == null) continue;
                                this.setBlockState(state, world, pos.func_177958_n() + model.length - z - 1, pos.func_177956_o() + y, pos.func_177952_p() + x, lootLevel);
                            }
                        }
                    }
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    for (int x = 0; x < model.width; ++x) {
                        for (int y = 0; y < model.height; ++y) {
                            for (int z = 0; z < model.length; ++z) {
                                BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : (model.model[x][y][z].type == DungeonSegmentModelBlockType.FWB_PLACEHOLDER ? DungeonSegmentModelBlock.getBlockState(model.fourWayBlocks[fwb++], theme, world.func_201674_k(), Rotation.COUNTERCLOCKWISE_90) : (model.model[x][y][z].type == DungeonSegmentModelBlockType.TRAPDOOR ? DungeonSegmentModelBlock.getBlockState(model.trapDoors[td++], theme, world.func_201674_k(), Rotation.COUNTERCLOCKWISE_90) : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), Rotation.COUNTERCLOCKWISE_90)));
                                if (state == null) continue;
                                this.setBlockState(state, world, pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() + model.width - x - 1, lootLevel);
                            }
                        }
                    }
                    break;
                }
                case CLOCKWISE_180: {
                    for (int x = 0; x < model.width; ++x) {
                        for (int y = 0; y < model.height; ++y) {
                            for (int z = 0; z < model.length; ++z) {
                                BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : (model.model[x][y][z].type == DungeonSegmentModelBlockType.FWB_PLACEHOLDER ? DungeonSegmentModelBlock.getBlockState(model.fourWayBlocks[fwb++], theme, world.func_201674_k(), Rotation.CLOCKWISE_180) : (model.model[x][y][z].type == DungeonSegmentModelBlockType.TRAPDOOR ? DungeonSegmentModelBlock.getBlockState(model.trapDoors[td++], theme, world.func_201674_k(), Rotation.CLOCKWISE_180) : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), Rotation.CLOCKWISE_180)));
                                if (state == null) continue;
                                this.setBlockState(state, world, pos.func_177958_n() + model.width - x - 1, pos.func_177956_o() + y, pos.func_177952_p() + model.length - z - 1, lootLevel);
                            }
                        }
                    }
                    break;
                }
                case NONE: {
                    this.build(model, world, pos, theme, lootLevel);
                    break;
                }
                default: {
                    DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unknown rotation " + rotation);
                }
            }
        }

        public static Direction getOneWayDirection(DungeonPiece piece) {
            if (piece.sides[0]) {
                return Direction.NORTH;
            }
            if (piece.sides[1]) {
                return Direction.EAST;
            }
            if (piece.sides[2]) {
                return Direction.SOUTH;
            }
            if (piece.sides[3]) {
                return Direction.WEST;
            }
            return Direction.NORTH;
        }

        public static Direction getOpenSide(DungeonPiece piece, int n) {
            int c = 0;
            for (int i = 0; i < 4; ++i) {
                if (!piece.sides[i] || c++ != n) continue;
                return DungeonPiece.getDirectionFromInt(i);
            }
            DungeonCrawl.LOGGER.error("getOpenSide(" + (Object)((Object)piece) + ", " + n + ") malfunctioned. This error did most likely occur due to an error in the mod and might result in wrongly formed dungeons. (" + piece.connectedSides + " open sides)");
            return Direction.NORTH;
        }

        public static Direction getDirectionFromInt(int dir) {
            switch (dir) {
                case 0: {
                    return Direction.NORTH;
                }
                case 1: {
                    return Direction.EAST;
                }
                case 2: {
                    return Direction.SOUTH;
                }
                case 3: {
                    return Direction.WEST;
                }
            }
            return Direction.NORTH;
        }
    }

    public static class StairsBot
    extends DungeonPiece {
        public StairsBot(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.STAIRSBOT, p_i51343_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            super.func_74861_a(componentIn, listIn, rand);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            this.build(model, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), this.stage);
            this.addWalls(this, worldIn, Theme.get(this.theme));
            return true;
        }

        @Override
        public int getType() {
            return 1;
        }

        public void addWalls(DungeonPiece piece, IWorld world, Theme theme) {
            int z;
            int y;
            int x;
            if (!piece.sides[0]) {
                for (x = 2; x < 6; ++x) {
                    for (y = 2; y < 6; ++y) {
                        piece.setBlockState(theme.wall.get(), world, piece.x + x, piece.y + y, piece.z, 0);
                    }
                }
            } else {
                for (x = 2; x < 6; ++x) {
                    for (y = 2; y < 6; ++y) {
                        if (world.func_180495_p(new BlockPos(piece.x + x, piece.y + y, piece.z)).func_200132_m()) continue;
                        piece.setBlockState(Blocks.field_150411_aY.func_176223_P(), world, piece.x + x, piece.y + y, piece.z, 0);
                    }
                }
            }
            if (!piece.sides[1]) {
                for (z = 2; z < 6; ++z) {
                    for (y = 2; y < 6; ++y) {
                        piece.setBlockState(theme.wall.get(), world, piece.x + 7, piece.y + y, piece.z + z, 0);
                    }
                }
            } else {
                for (z = 2; z < 6; ++z) {
                    for (y = 2; y < 6; ++y) {
                        if (world.func_180495_p(new BlockPos(piece.x + 7, piece.y + y, piece.z + z)).func_200132_m()) continue;
                        piece.setBlockState(Blocks.field_150411_aY.func_176223_P(), world, piece.x + 7, piece.y + y, piece.z + z, 0);
                    }
                }
            }
            if (!piece.sides[2]) {
                for (x = 2; x < 6; ++x) {
                    for (y = 2; y < 6; ++y) {
                        piece.setBlockState(theme.wall.get(), world, piece.x + x, piece.y + y, piece.z + 7, 0);
                    }
                }
            } else {
                for (x = 2; x < 6; ++x) {
                    for (y = 2; y < 6; ++y) {
                        if (world.func_180495_p(new BlockPos(piece.x + x, piece.y + y, piece.z + 7)).func_200132_m()) continue;
                        piece.setBlockState(Blocks.field_150411_aY.func_176223_P(), world, piece.x + x, piece.y + y, piece.z + 7, 0);
                    }
                }
            }
            if (!piece.sides[3]) {
                for (z = 2; z < 6; ++z) {
                    for (y = 2; y < 6; ++y) {
                        piece.setBlockState(theme.wall.get(), world, piece.x, piece.y + y, piece.z + z, 0);
                    }
                }
            } else {
                for (z = 2; z < 6; ++z) {
                    for (y = 2; y < 6; ++y) {
                        if (world.func_180495_p(new BlockPos(piece.x, piece.y + y, piece.z + z)).func_200132_m()) continue;
                        piece.setBlockState(Blocks.field_150411_aY.func_176223_P(), world, piece.x, piece.y + y, piece.z + z, 0);
                    }
                }
            }
        }
    }

    public static class Stairs
    extends DungeonPiece {
        public Stairs(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.STAIRS, p_i51343_2_);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            int y1;
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            Theme buildTheme = Theme.get(this.theme);
            this.build(model, worldIn, new BlockPos(this.x, this.y, this.z), buildTheme, this.stage);
            for (int x1 = 0; x1 < 8; ++x1) {
                for (y1 = 0; y1 < 8; ++y1) {
                    this.setBlockState(buildTheme.wall.get(), worldIn, this.x + x1, this.y + y1, this.z + 7, 0);
                }
            }
            for (int z1 = 0; z1 < 8; ++z1) {
                for (y1 = 0; y1 < 8; ++y1) {
                    this.setBlockState(buildTheme.wall.get(), worldIn, this.x + 7, this.y + y1, this.z + z1, 0);
                }
            }
            return true;
        }

        @Override
        public int getType() {
            return 2;
        }
    }

    public static class StairsTop
    extends DungeonPiece {
        public StairsTop(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.STAIRSTOP, p_i51343_2_);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            this.build(model, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), this.stage);
            DungeonPieces.addWalls(this, worldIn, Theme.get(this.theme));
            return true;
        }

        @Override
        public int getType() {
            return 3;
        }
    }

    public static class EntranceBuilder
    extends DungeonPiece {
        public EntranceBuilder(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.ENTRANCE_BUILDER, p_i51343_2_);
        }

        @Override
        public int getType() {
            return 11;
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            int ch;
            int height = DungeonPieces.getGroudHeight(worldIn, this.x + 4, this.z + 4);
            Theme buildTheme = Theme.get(this.theme);
            for (ch = this.y; ch < height; ch += 8) {
                int y1;
                this.build(DungeonSegmentModelRegistry.STAIRS, worldIn, new BlockPos(this.x, ch, this.z), buildTheme, this.stage);
                for (int x1 = 0; x1 < 8; ++x1) {
                    for (y1 = 0; y1 < 8; ++y1) {
                        this.setBlockState(buildTheme.wall.get(), worldIn, this.x + x1, ch + y1, this.z + 7, 0);
                    }
                }
                for (int z1 = 0; z1 < 8; ++z1) {
                    for (y1 = 0; y1 < 8; ++y1) {
                        this.setBlockState(buildTheme.wall.get(), worldIn, this.x + 7, ch + y1, this.z + z1, 0);
                    }
                }
            }
            this.build(DungeonSegmentModelRegistry.ENTRANCE, worldIn, new BlockPos(this.x, ch, this.z), buildTheme, this.stage);
            return false;
        }
    }

    public static class Hole
    extends DungeonPiece {
        boolean lava;

        public Hole(TemplateManager p_i51343_1_, CompoundNBT p_i51343_2_) {
            super(Dungeon.HOLE, p_i51343_2_);
            this.lava = p_i51343_2_.func_74767_n("lava");
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            this.build(this.lava ? DungeonSegmentModelRegistry.HOLE_LAVA : DungeonSegmentModelRegistry.HOLE, worldIn, new BlockPos(this.x, this.y - 15, this.z), Theme.get(this.theme), this.stage);
            DungeonPieces.addWalls(this, worldIn, Theme.get(this.theme));
            return false;
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("lava", this.lava);
        }
    }

    public static class CorridorTrap
    extends DungeonPiece {
        public CorridorTrap(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.CORRIDOR_TRAP, p_i51343_2_);
        }

        @Override
        public int getType() {
            return 6;
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            this.buildRotated(DungeonSegmentModelRegistry.CORRIDOR_TRAP, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), this.stage, this.func_214809_Y_());
            return true;
        }
    }

    public static class CorridorRoom
    extends DungeonPiece {
        public CorridorRoom(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.CORRIDOR_ROOM, p_i51343_2_);
        }

        @Override
        public int getType() {
            return 7;
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            this.buildRotated(DungeonSegmentModelRegistry.CORRIDOR_ROOM, worldIn, new BlockPos(this.x, this.y - 6, this.z), Theme.get(this.theme), this.stage, this.func_214809_Y_());
            return true;
        }
    }

    public static class Corridor
    extends DungeonPiece {
        public Corridor(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.CORRIDOR, p_i51343_2_);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.getAirBlocks(worldIn, this.x, this.y, this.z, 8, 8) > 8) {
                boolean ew = this.field_186169_c == Rotation.NONE || this.field_186169_c == Rotation.CLOCKWISE_180;
                switch (this.connectedSides) {
                    case 2: {
                        if (this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3]) {
                            this.buildRotated(DungeonSegmentModelRegistry.BRIDGE, worldIn, new BlockPos(ew ? this.x : this.x + 1, this.y - 1, ew ? this.z + 1 : this.z), Theme.get(this.theme), this.stage, this.field_186169_c);
                        } else {
                            this.buildRotated(DungeonSegmentModelRegistry.BRIDGE_TURN, worldIn, new BlockPos(this.x, this.y - 1, this.z), Theme.get(this.theme), this.stage, this.field_186169_c);
                        }
                        return true;
                    }
                    case 3: {
                        this.buildRotated(DungeonSegmentModelRegistry.BRIDGE_SIDE, worldIn, new BlockPos(this.x, this.y - 1, this.z), Theme.get(this.theme), this.stage, this.field_186169_c);
                        return true;
                    }
                    case 4: {
                        this.buildRotated(DungeonSegmentModelRegistry.BRIDGE_ALL_SIDES, worldIn, new BlockPos(this.x, this.y - 1, this.z), Theme.get(this.theme), this.stage, this.field_186169_c);
                        return true;
                    }
                }
                return true;
            }
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            this.buildRotated(model, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), this.stage, this.func_214809_Y_());
            return true;
        }

        @Override
        public int getType() {
            return 0;
        }

        public int getAirBlocks(IWorld worldIn, int x, int y, int z, int width, int length) {
            int airBlocks = 0;
            for (int i = x; i < x + width; ++i) {
                for (int j = z; j < z + length; ++j) {
                    Block block = worldIn.func_180495_p(new BlockPos(i, y, j)).func_177230_c();
                    if (block != Blocks.field_150350_a && block != Blocks.field_201941_jj) continue;
                    ++airBlocks;
                }
            }
            return airBlocks;
        }
    }

    public static class Room
    extends DungeonPiece {
        public Room(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.ROOM, p_i51343_2_);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            this.build(model, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), this.stage);
            DungeonPieces.addWalls(this, worldIn, Theme.get(this.theme));
            return false;
        }

        @Override
        public int getType() {
            return 5;
        }
    }

    public static class Part
    extends DungeonPiece {
        private int modelID;
        private int startX;
        private int startY;
        private int startZ;
        private int width;
        private int height;
        private int length;

        public Part(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.PART, p_i51343_2_);
            this.modelID = p_i51343_2_.func_74762_e("model");
            this.startX = p_i51343_2_.func_74762_e("startX");
            this.startY = p_i51343_2_.func_74762_e("startY");
            this.startZ = p_i51343_2_.func_74762_e("startZ");
            this.width = p_i51343_2_.func_74762_e("width");
            this.height = p_i51343_2_.func_74762_e("height");
            this.length = p_i51343_2_.func_74762_e("length");
        }

        public void set(int modelID, int startX, int startY, int startZ, int width, int height, int length) {
            this.modelID = modelID;
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.width = width;
            this.height = height;
            this.length = length;
        }

        public void adjustSize() {
            DungeonSegmentModel model = DungeonSegmentModelRegistry.MAP.get(this.modelID);
            if (model == null) {
                DungeonCrawl.LOGGER.warn("Failed to adjust the size of a dungeon part. ID: {}", (Object)this.modelID);
                return;
            }
            this.width = this.startX + this.width > model.width ? this.width - (this.startX + this.width - model.width) : this.width;
            this.height = this.startY + this.height > model.height ? this.height - (this.startY + this.height - model.height) : this.height;
            this.length = this.startZ + this.length > model.length ? this.length - (this.startZ + this.length - model.length) : this.length;
        }

        @Override
        public int getType() {
            return 12;
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            this.adjustSize();
            DungeonSegmentModel model = DungeonSegmentModelRegistry.MAP.get(this.modelID);
            BlockPos pos = new BlockPos(this.x, this.y, this.z);
            int fwb = 0;
            int td = 0;
            for (int x = this.startX; x < this.startX + this.width; ++x) {
                for (int y = this.startY; y < this.startY + this.height; ++y) {
                    for (int z = this.startZ; z < this.startZ + this.length; ++z) {
                        BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : (model.model[x][y][z].type == DungeonSegmentModelBlockType.FWB_PLACEHOLDER ? DungeonSegmentModelBlock.getBlockState(model.fourWayBlocks[fwb++], Theme.get(this.theme), worldIn.func_201674_k()) : (model.model[x][y][z].type == DungeonSegmentModelBlockType.TRAPDOOR ? DungeonSegmentModelBlock.getBlockState(model.trapDoors[td++], Theme.get(this.theme), worldIn.func_201674_k()) : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], Theme.get(this.theme), worldIn.func_201674_k())));
                        if (state == null) continue;
                        this.setBlockState(state, worldIn, pos.func_177958_n() + x - this.startX, pos.func_177956_o() + y - this.startY, pos.func_177952_p() + z - this.startZ, this.stage);
                    }
                }
            }
            DungeonPieces.addWalls(this, worldIn, Theme.get(this.theme));
            return true;
        }

        @Override
        public void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("model", this.modelID);
            tagCompound.func_74768_a("startX", this.startX);
            tagCompound.func_74768_a("startY", this.startY);
            tagCompound.func_74768_a("startZ", this.startZ);
            tagCompound.func_74768_a("width", this.width);
            tagCompound.func_74768_a("height", this.height);
            tagCompound.func_74768_a("length", this.length);
        }
    }

    public static class DungeonPieceLarge
    extends StructurePiece {
        public Rotation field_186169_c;
        public int connectedSides;
        public int posX;
        public int posZ;
        public int theme;
        public int x;
        public int y;
        public int z;
        public int stage;
        public boolean[] sides = new boolean[8];

        public DungeonPieceLarge(IStructurePieceType p_i51343_1_, CompoundNBT p_i51343_2_) {
            super(p_i51343_1_, p_i51343_2_);
            this.sides[0] = p_i51343_2_.func_74767_n("north1");
            this.sides[1] = p_i51343_2_.func_74767_n("north2");
            this.sides[2] = p_i51343_2_.func_74767_n("east1");
            this.sides[3] = p_i51343_2_.func_74767_n("east2");
            this.sides[4] = p_i51343_2_.func_74767_n("south1");
            this.sides[5] = p_i51343_2_.func_74767_n("south2");
            this.sides[6] = p_i51343_2_.func_74767_n("west1");
            this.sides[7] = p_i51343_2_.func_74767_n("west2");
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            super.func_74861_a(componentIn, listIn, rand);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return false;
        }

        public void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74757_a("north1", this.sides[0]);
            tagCompound.func_74757_a("north2", this.sides[1]);
            tagCompound.func_74757_a("east1", this.sides[2]);
            tagCompound.func_74757_a("east2", this.sides[3]);
            tagCompound.func_74757_a("south1", this.sides[4]);
            tagCompound.func_74757_a("south2", this.sides[5]);
            tagCompound.func_74757_a("west1", this.sides[6]);
            tagCompound.func_74757_a("west2", this.sides[7]);
            tagCompound.func_74768_a("connectedSides", this.connectedSides);
            tagCompound.func_74768_a("posX", this.posX);
            tagCompound.func_74768_a("posZ", this.posZ);
            tagCompound.func_74768_a("x", this.x);
            tagCompound.func_74768_a("y", this.y);
            tagCompound.func_74768_a("z", this.z);
            tagCompound.func_74768_a("theme", this.theme);
            tagCompound.func_74768_a("stage", this.stage);
            tagCompound.func_74768_a("rotation", RotationHelper.getIntFromRotation(this.field_186169_c));
        }

        public void setBlockState(BlockState state, IWorld world, int x, int y, int z, int lootLevel) {
            BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (state == null) {
                return;
            }
            IBlockPlacementHandler.getHandler(state.func_177230_c()).setupBlock(world, state, pos, world.func_201674_k(), lootLevel);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
                world.func_217349_x(pos).func_201594_d(pos);
            }
        }

        public void build(DungeonSegmentModel model, IWorld world, BlockPos pos, Theme theme, int lootLevel) {
            int fwb = 0;
            int td = 0;
            for (int x = 0; x < model.width; ++x) {
                for (int y = 0; y < model.height; ++y) {
                    for (int z = 0; z < model.length; ++z) {
                        BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : (model.model[x][y][z].type == DungeonSegmentModelBlockType.FWB_PLACEHOLDER ? DungeonSegmentModelBlock.getBlockState(model.fourWayBlocks[fwb++], theme, world.func_201674_k()) : (model.model[x][y][z].type == DungeonSegmentModelBlockType.TRAPDOOR ? DungeonSegmentModelBlock.getBlockState(model.trapDoors[td++], theme, world.func_201674_k()) : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k())));
                        if (state == null) continue;
                        this.setBlockState(state, world, pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z, lootLevel);
                    }
                }
            }
        }

        public void buildRotated(DungeonSegmentModel model, IWorld world, BlockPos pos, Theme theme, int lootLevel, Rotation rotation) {
            int fwb = 0;
            int td = 0;
            switch (rotation) {
                case CLOCKWISE_90: {
                    for (int x = 0; x < model.width; ++x) {
                        for (int y = 0; y < model.height; ++y) {
                            for (int z = 0; z < model.length; ++z) {
                                BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : (model.model[x][y][z].type == DungeonSegmentModelBlockType.FWB_PLACEHOLDER ? DungeonSegmentModelBlock.getBlockState(model.fourWayBlocks[fwb++], theme, world.func_201674_k(), Rotation.CLOCKWISE_90) : (model.model[x][y][z].type == DungeonSegmentModelBlockType.TRAPDOOR ? DungeonSegmentModelBlock.getBlockState(model.trapDoors[td++], theme, world.func_201674_k(), Rotation.CLOCKWISE_90) : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), Rotation.CLOCKWISE_90)));
                                if (state == null) continue;
                                this.setBlockState(state, world, pos.func_177958_n() + model.length - z - 1, pos.func_177956_o() + y, pos.func_177952_p() + x, lootLevel);
                            }
                        }
                    }
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    for (int x = 0; x < model.width; ++x) {
                        for (int y = 0; y < model.height; ++y) {
                            for (int z = 0; z < model.length; ++z) {
                                BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : (model.model[x][y][z].type == DungeonSegmentModelBlockType.FWB_PLACEHOLDER ? DungeonSegmentModelBlock.getBlockState(model.fourWayBlocks[fwb++], theme, world.func_201674_k(), Rotation.COUNTERCLOCKWISE_90) : (model.model[x][y][z].type == DungeonSegmentModelBlockType.TRAPDOOR ? DungeonSegmentModelBlock.getBlockState(model.trapDoors[td++], theme, world.func_201674_k(), Rotation.COUNTERCLOCKWISE_90) : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), Rotation.COUNTERCLOCKWISE_90)));
                                if (state == null) continue;
                                this.setBlockState(state, world, pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() + model.width - x - 1, lootLevel);
                            }
                        }
                    }
                    break;
                }
                case CLOCKWISE_180: {
                    for (int x = 0; x < model.width; ++x) {
                        for (int y = 0; y < model.height; ++y) {
                            for (int z = 0; z < model.length; ++z) {
                                BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : (model.model[x][y][z].type == DungeonSegmentModelBlockType.FWB_PLACEHOLDER ? DungeonSegmentModelBlock.getBlockState(model.fourWayBlocks[fwb++], theme, world.func_201674_k(), Rotation.CLOCKWISE_180) : (model.model[x][y][z].type == DungeonSegmentModelBlockType.TRAPDOOR ? DungeonSegmentModelBlock.getBlockState(model.trapDoors[td++], theme, world.func_201674_k(), Rotation.CLOCKWISE_180) : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), Rotation.CLOCKWISE_180)));
                                if (state == null) continue;
                                this.setBlockState(state, world, pos.func_177958_n() + model.width - x - 1, pos.func_177956_o() + y, pos.func_177952_p() + model.length - z - 1, lootLevel);
                            }
                        }
                    }
                    break;
                }
                case NONE: {
                    this.build(model, world, pos, theme, lootLevel);
                    break;
                }
                default: {
                    DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unknown rotation " + rotation);
                }
            }
        }

        public void openSide(int side) {
            if (this.sides[side]) {
                return;
            }
            this.sides[side] = true;
            ++this.connectedSides;
        }

        public static Direction getOneWayDirection(DungeonPiece piece) {
            if (piece.sides[0]) {
                return Direction.NORTH;
            }
            if (piece.sides[1]) {
                return Direction.EAST;
            }
            if (piece.sides[2]) {
                return Direction.SOUTH;
            }
            if (piece.sides[3]) {
                return Direction.WEST;
            }
            return Direction.NORTH;
        }

        public static Direction getOpenSide(DungeonPiece piece, int n) {
            int c = 0;
            for (int i = 0; i < 4; ++i) {
                if (!piece.sides[i] || c++ != n) continue;
                return DungeonPieceLarge.getDirectionFromInt(i);
            }
            DungeonCrawl.LOGGER.error("getOpenSide(" + (Object)((Object)piece) + ", " + n + ") malfunctioned. This error did most likely occur due to an error in the mod and might result in wrongly formed dungeons. (" + piece.connectedSides + " open sides)");
            return Direction.NORTH;
        }

        public static Direction getDirectionFromInt(int dir) {
            switch (dir) {
                case 0: {
                    return Direction.NORTH;
                }
                case 1: {
                    return Direction.EAST;
                }
                case 2: {
                    return Direction.SOUTH;
                }
                case 3: {
                    return Direction.WEST;
                }
            }
            return Direction.NORTH;
        }

        public static void addWalls(DungeonPieceLarge piece, IWorld world) {
            if (!piece.sides[0]) {
                for (int x = 2; x < 6; ++x) {
                    for (int y = 2; y < 6; ++y) {
                        piece.setBlockState(BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE.get(), world, piece.x + x, piece.y + y, piece.z, 0);
                    }
                }
            }
        }
    }

    public static class RoomLargePlaceholder
    extends DungeonPiece {
        public RoomLargePlaceholder(IStructurePieceType p_i51343_1_, CompoundNBT p_i51343_2_) {
            super(p_i51343_1_, p_i51343_2_);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return false;
        }

        @Override
        public int getType() {
            return 99;
        }
    }
}

