/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.dungeon.monster.ArmorSet;
import xiroc.dungeoncrawl.util.IRandom;

public class RandomEquipment {
    public static final int HIGHEST_STAGE = 2;
    public static final int[] ARMOR_COLORS = new int[]{11546150, 16701501, 3949738, 6192150, 16351261, 0xF9FFFE, 15961002, 0x1D1D21, 8439583, 4673362, 1481884, 8991416, 3847130};
    public static final Set<String> COLORED_ARMOR = ImmutableSet.builder().add((Object)"minecraft:leather_boots").add((Object)"minecraft:leather_pants").add((Object)"minecraft:leather_chestplate").add((Object)"minecraft:leather_helmet").build();
    public static final ResourceLocation[] BOWS = new ResourceLocation[]{new ResourceLocation("minecraft:bow")};
    public static final ResourceLocation[] SWORDS = new ResourceLocation[]{new ResourceLocation("minecraft:stone_sword"), new ResourceLocation("minecraft:golden_sword"), new ResourceLocation("minecraft:iron_sword")};
    public static final ResourceLocation[] SWORDS_RARE = new ResourceLocation[]{new ResourceLocation("minecraft:wooden_sword"), new ResourceLocation("minecraft:diamond_sword")};
    public static final ResourceLocation[] PICKAXES = new ResourceLocation[]{new ResourceLocation("minecraft:stone_pickaxe"), new ResourceLocation("minecraft:golden_pickaxe"), new ResourceLocation("minecraft:iron_pickaxe")};
    public static final ResourceLocation[] AXES = new ResourceLocation[]{new ResourceLocation("minecraft:stone_axe"), new ResourceLocation("minecraft:golden_axe"), new ResourceLocation("minecraft:iron_axe"), new ResourceLocation("minecraft:diamond_axe")};
    public static final ArmorSet[] ARMOR_SETS_1 = new ArmorSet[]{new ArmorSet("minecraft:leather_boots", "minecraft:leather_leggings", "minecraft:leather_chestplate", "minecraft:leather_helmet")};
    public static final ArmorSet[] ARMOR_SETS_2 = new ArmorSet[]{new ArmorSet("minecraft:leather_boots", "minecraft:leather_leggings", "minecraft:leather_chestplate", "minecraft:leather_helmet"), new ArmorSet("minecraft:golden_boots", "minecraft:golden_leggings", "minecraft:golden_chestplate", "minecraft:golden_helmet"), new ArmorSet("minecraft:chainmail_boots", "minecraft:chainmail_leggings", "minecraft:chainmail_chestplate", "minecraft:chainmail_helmet"), new ArmorSet("minecraft:iron_boots", "minecraft:iron_leggings", "minecraft:iron_chestplate", "minecraft:iron_helmet")};
    public static final ArmorSet[] ARMOR_SETS_3 = new ArmorSet[]{new ArmorSet("minecraft:leather_boots", "minecraft:leather_leggings", "minecraft:leather_chestplate", "minecraft:leather_helmet"), new ArmorSet("minecraft:golden_boots", "minecraft:golden_leggings", "minecraft:golden_chestplate", "minecraft:golden_helmet"), new ArmorSet("minecraft:chainmail_boots", "minecraft:chainmail_leggings", "minecraft:chainmail_chestplate", "minecraft:chainmail_helmet"), new ArmorSet("minecraft:iron_boots", "minecraft:iron_leggings", "minecraft:iron_chestplate", "minecraft:iron_helmet")};
    public static final ArmorSet[] ARMOR_SETS_RARE = new ArmorSet[]{new ArmorSet("minecraft:diamond_boots", "minecraft:diamond_leggings", "minecraft:diamond_chestplate", "minecraft:diamond_helmet")};
    public static final ResourceLocation[] BOW_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:power"), new ResourceLocation("minecraft:unbreaking"), new ResourceLocation("minecraft:punch")};
    public static final ResourceLocation[] SWORD_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:sharpness"), new ResourceLocation("minecraft:unbreaking"), new ResourceLocation("minecraft:fire_aspect"), new ResourceLocation("minecraft:knockback")};
    public static final ResourceLocation[] PICKAXE_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:efficiency")};
    public static final ResourceLocation[] AXE_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:efficiency")};
    public static final ResourceLocation[] ARMOR_ENCHANTMENTS = new ResourceLocation[]{new ResourceLocation("minecraft:protection"), new ResourceLocation("minecraft:unbreaking"), new ResourceLocation("minecraft:thorns"), new ResourceLocation("minecraft:projectile_protection")};
    public static final IRandom<ItemStack> BOW = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(BOWS[rand.nextInt(BOWS.length)]));
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> SWORD = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem((double)rand.nextFloat() < 0.05 ? SWORDS_RARE[rand.nextInt(SWORDS_RARE.length)] : SWORDS[rand.nextInt(SWORDS.length)]));
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> PICKAXE = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(PICKAXES[rand.nextInt(PICKAXES.length)]));
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack> AXE = rand -> {
        ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(AXES[rand.nextInt(AXES.length)]));
        RandomEquipment.applyDamage(item, rand);
        return item;
    };
    public static final IRandom<ItemStack[]> ARMOR_1 = rand -> {
        ItemStack[] items = new ItemStack[4];
        ArmorSet armor = ARMOR_SETS_1[rand.nextInt(ARMOR_SETS_1.length)];
        for (int i = 0; i < 4; ++i) {
            if ((double)rand.nextFloat() < 0.5) {
                ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(armor.items[i]));
                RandomEquipment.enchantArmor(item, rand, 0.25);
                RandomEquipment.applyDamage(item, rand);
                if (COLORED_ARMOR.contains(armor.items[i].toString())) {
                    RandomEquipment.setArmorColor(item, RandomEquipment.getRandomColor(rand));
                }
                items[i] = item;
                continue;
            }
            items[i] = ItemStack.field_190927_a;
        }
        return items;
    };
    public static final IRandom<ItemStack[]> ARMOR_2 = rand -> {
        ItemStack[] items = new ItemStack[4];
        ArmorSet armor = ARMOR_SETS_2[rand.nextInt(ARMOR_SETS_2.length)];
        for (int i = 0; i < 4; ++i) {
            if ((double)rand.nextFloat() < 0.5) {
                ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(armor.items[i]));
                RandomEquipment.enchantArmor(item, rand, 0.5);
                RandomEquipment.applyDamage(item, rand);
                if (COLORED_ARMOR.contains(armor.items[i].toString())) {
                    RandomEquipment.setArmorColor(item, RandomEquipment.getRandomColor(rand));
                }
                items[i] = item;
                continue;
            }
            items[i] = ItemStack.field_190927_a;
        }
        return items;
    };
    public static final IRandom<ItemStack[]> ARMOR_3 = rand -> {
        ItemStack[] items = new ItemStack[4];
        ArmorSet armor = (double)rand.nextFloat() < 0.05 ? ARMOR_SETS_RARE[rand.nextInt(ARMOR_SETS_RARE.length)] : ARMOR_SETS_3[rand.nextInt(ARMOR_SETS_3.length)];
        for (int i = 0; i < 4; ++i) {
            if ((double)rand.nextFloat() < 0.5) {
                ItemStack item = new ItemStack((IItemProvider)RandomEquipment.getItem(armor.items[i]));
                RandomEquipment.enchantArmor(item, rand, 1.0);
                RandomEquipment.applyDamage(item, rand);
                if (COLORED_ARMOR.contains(armor.items[i].toString())) {
                    RandomEquipment.setArmorColor(item, RandomEquipment.getRandomColor(rand));
                }
                items[i] = item;
                continue;
            }
            items[i] = ItemStack.field_190927_a;
        }
        return items;
    };

    public static void applyDamage(ItemStack item, Random rand) {
        item.func_196085_b(rand.nextInt(item.func_77958_k()));
    }

    public static ItemStack enchantItem(ItemStack item, Random rand, Enchantment enchantment, double multiplier) {
        int maxLevel;
        int minLevel = enchantment.func_77319_d();
        item.func_77966_a(enchantment, minLevel < (maxLevel = (int)((double)enchantment.func_77325_b() * multiplier)) ? minLevel + rand.nextInt(maxLevel - minLevel) : minLevel);
        return item;
    }

    public static ItemStack enchantBow(ItemStack item, Random rand, double multiplier) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(BOW_ENCHANTMENTS[rand.nextInt(BOW_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static ItemStack enchantArmor(ItemStack item, Random rand, double multiplier) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ARMOR_ENCHANTMENTS[rand.nextInt(ARMOR_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static ItemStack enchantSword(ItemStack item, Random rand, double multiplier) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(SWORD_ENCHANTMENTS[rand.nextInt(SWORD_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static ItemStack enchantPickaxe(ItemStack item, Random rand, double multiplier) {
        RandomEquipment.enchantSword(item, rand, multiplier);
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(PICKAXE_ENCHANTMENTS[rand.nextInt(PICKAXE_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static ItemStack enchantAxe(ItemStack item, Random rand, double multiplier) {
        RandomEquipment.enchantSword(item, rand, multiplier);
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(AXE_ENCHANTMENTS[rand.nextInt(AXE_ENCHANTMENTS.length)]);
        RandomEquipment.enchantItem(item, rand, enchantment, multiplier);
        return item;
    }

    public static void setArmorColor(ItemStack item, int color) {
        CompoundNBT tag = item.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        CompoundNBT display = new CompoundNBT();
        display.func_74768_a("color", color);
        tag.func_218657_a("display", (INBT)display);
        item.func_77982_d(tag);
    }

    public static ItemStack getMeleeWeapon(Random rand, int stage) {
        switch (rand.nextInt(3)) {
            case 0: {
                return RandomEquipment.enchantSword(SWORD.roll(rand), rand, RandomEquipment.getStageMultiplier(stage));
            }
            case 1: {
                return RandomEquipment.enchantPickaxe(PICKAXE.roll(rand), rand, RandomEquipment.getStageMultiplier(stage));
            }
            case 2: {
                return RandomEquipment.enchantAxe(AXE.roll(rand), rand, RandomEquipment.getStageMultiplier(stage));
            }
        }
        return null;
    }

    public static ItemStack getRangedWeapon(Random rand, int stage) {
        return RandomEquipment.enchantBow(BOW.roll(rand), rand, RandomEquipment.getStageMultiplier(stage));
    }

    public static double getStageMultiplier(int stage) {
        return 1.0 * Math.pow(0.5, 2 - stage);
    }

    public static int getRandomColor(Random rand) {
        return ARMOR_COLORS[rand.nextInt(ARMOR_COLORS.length)];
    }

    public static Item getItem(ResourceLocation resourceLocation) {
        return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
    }
}

