/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.segment;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.TripWireHookBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelFourWayBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelTrapDoorBlock;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IDungeonSegmentBlockStateProvider;

public class DungeonSegmentModelBlock {
    public static HashMap<DungeonSegmentModelBlockType, IDungeonSegmentBlockStateProvider> PROVIDERS = new HashMap();
    public DungeonSegmentModelBlockType type;
    public Direction facing;
    public Boolean upsideDown;

    public DungeonSegmentModelBlock(DungeonSegmentModelBlockType type) {
        this.type = type;
    }

    public DungeonSegmentModelBlock(DungeonSegmentModelBlockType type, Direction facing, boolean upsideDown) {
        if (facing == null && !upsideDown) {
            this.type = type;
            return;
        }
        this.type = type;
        this.facing = facing;
        this.upsideDown = upsideDown;
    }

    public static void load() {
        PROVIDERS.put(DungeonSegmentModelBlockType.NONE, (block, theme, rand) -> null);
        PROVIDERS.put(DungeonSegmentModelBlockType.ANVIL, (block, theme, rand) -> (BlockState)Blocks.field_150467_bQ.func_176223_P().func_206870_a((IProperty)AnvilBlock.field_176506_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.BARREL, (block, theme, rand) -> (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((IProperty)BarrelBlock.field_220092_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.CEILING, (block, theme, rand) -> theme.ceiling.get());
        PROVIDERS.put(DungeonSegmentModelBlockType.CEILING_STAIRS, (block, theme, rand) -> (BlockState)((BlockState)theme.ceilingStairs.get().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)block.facing)).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM)));
        PROVIDERS.put(DungeonSegmentModelBlockType.CHEST_COMMON, (block, theme, rand) -> (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.DISPENSER, (block, theme, rand) -> (BlockState)Blocks.field_150367_z.func_176223_P().func_206870_a((IProperty)DispenserBlock.field_176441_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.FLOOR, (block, theme, rand) -> theme.floor.get());
        PROVIDERS.put(DungeonSegmentModelBlockType.FLOOR_STAIRS, (block, theme, rand) -> (BlockState)((BlockState)theme.floorStairs.get().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)block.facing)).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM)));
        PROVIDERS.put(DungeonSegmentModelBlockType.FURNACE, (block, theme, rand) -> (BlockState)((BlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((IProperty)FurnaceBlock.field_220090_a, (Comparable)block.facing)).func_206870_a((IProperty)FurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(true)));
        PROVIDERS.put(DungeonSegmentModelBlockType.IRON_BARS, (block, theme, rand) -> {
            DungeonSegmentModelFourWayBlock fwb = (DungeonSegmentModelFourWayBlock)block;
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(fwb.north))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(fwb.east))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(fwb.south))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(fwb.west))).func_206870_a((IProperty)FourWayBlock.field_204514_u, (Comparable)Boolean.valueOf(fwb.waterlogged));
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.LAVA, (block, theme, rand) -> Blocks.field_150353_l.func_176223_P());
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_FLOOR_CHESTCOMMON_SPAWNER, (block, theme, rand) -> {
            int i = rand.nextInt(10);
            if (i < 2) {
                return BlockRegistry.SPAWNER;
            }
            if (i == 5) {
                return (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing);
            }
            return theme.floor.get();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_FLOOR_LAVA, (block, theme, rand) -> {
            switch (rand.nextInt(2)) {
                case 0: {
                    return theme.floor.get();
                }
                case 1: {
                    return Blocks.field_150353_l.func_176223_P();
                }
            }
            return Blocks.field_150353_l.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_FLOOR_WATER, (block, theme, rand) -> {
            switch (rand.nextInt(2)) {
                case 0: {
                    return theme.floor.get();
                }
                case 1: {
                    return Blocks.field_150355_j.func_176223_P();
                }
            }
            return Blocks.field_150355_j.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_WALL_AIR, (block, theme, rand) -> {
            if ((double)rand.nextFloat() < 0.75) {
                return theme.wall.get();
            }
            return Blocks.field_201941_jj.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_WALL_SPAWNER, (block, theme, rand) -> {
            switch (rand.nextInt(2)) {
                case 0: {
                    return BlockRegistry.SPAWNER;
                }
                case 1: {
                    return theme.wall.get();
                }
            }
            return BlockRegistry.SPAWNER;
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.STAIRS, (block, theme, rand) -> (BlockState)((BlockState)theme.stairs.get().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)block.facing)).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM)));
        PROVIDERS.put(DungeonSegmentModelBlockType.TORCH_DARK, (block, theme, rand) -> (BlockState)theme.torchDark.get().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.TRAPDOOR, (block, theme, rand) -> (BlockState)((BlockState)((BlockState)theme.trapDoorDecoration.get().func_206870_a((IProperty)TrapDoorBlock.field_176283_b, (Comparable)Boolean.valueOf(((DungeonSegmentModelTrapDoorBlock)block).open))).func_206870_a((IProperty)TrapDoorBlock.field_176285_M, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.TRIPWIRE, (block, theme, rand) -> (BlockState)Blocks.field_150473_bD.func_176223_P().func_206870_a((IProperty)TripWireBlock.field_176295_N, (Comparable)Boolean.valueOf(false)));
        PROVIDERS.put(DungeonSegmentModelBlockType.TRIPWIRE_HOOK, (block, theme, rand) -> (BlockState)((BlockState)Blocks.field_150479_bC.func_176223_P().func_206870_a((IProperty)TripWireHookBlock.field_176264_a, (Comparable)block.facing)).func_206870_a((IProperty)TripWireHookBlock.field_176265_M, (Comparable)Boolean.valueOf(true)));
        PROVIDERS.put(DungeonSegmentModelBlockType.WALL, (block, theme, rand) -> theme.wall.get());
        PROVIDERS.put(DungeonSegmentModelBlockType.WALL_LOG, (block, theme, rand) -> (BlockState)theme.wallLog.get().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
        PROVIDERS.put(DungeonSegmentModelBlockType.WATER, (block, theme, rand) -> Blocks.field_150355_j.func_176223_P());
        PROVIDERS.put(DungeonSegmentModelBlockType.WOOD, (block, theme, rand) -> Blocks.field_196662_n.func_176223_P());
    }

    public static BlockState getBlockState(DungeonSegmentModelBlock block, Theme theme, Random rand) {
        IDungeonSegmentBlockStateProvider provider = PROVIDERS.get((Object)block.type);
        if (provider == null) {
            return Blocks.field_201941_jj.func_176223_P();
        }
        BlockState state = provider.get(block, theme, rand);
        if (state == null) {
            return null;
        }
        return state;
    }

    public static BlockState getBlockState(DungeonSegmentModelBlock block, Theme theme, Random rand, Rotation rotation) {
        IDungeonSegmentBlockStateProvider provider = PROVIDERS.get((Object)block.type);
        if (provider == null) {
            return Blocks.field_201941_jj.func_176223_P();
        }
        BlockState state = provider.get(block, theme, rand);
        if (state == null) {
            return null;
        }
        return state.func_185907_a(rotation);
    }
}

