/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.part.block;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.util.Config;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Spawner
implements IBlockPlacementHandler {
    public static final EntityType<?>[] ENTITIES = new EntityType[]{EntityType.field_200725_aD, EntityType.field_200741_ag, EntityType.field_200727_aF, EntityType.field_200748_an, EntityType.field_200794_h, EntityType.field_200763_C};
    public static final EntityType<?>[] ENTITIES_RARE = new EntityType[]{EntityType.field_200740_af, EntityType.field_200797_k, EntityType.field_200759_ay, EntityType.field_200750_ap, EntityType.field_200803_q};
    public static final EntityType<?>[] ENTITIES_SPECIAL = new EntityType[]{EntityType.field_200792_f, EntityType.field_220352_aU};
    public static final Set<EntityType<?>> INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.field_200725_aD).add((Object)EntityType.field_200741_ag).add((Object)EntityType.field_200727_aF).add((Object)EntityType.field_200763_C).add((Object)EntityType.field_200750_ap).build();
    public static final Set<EntityType<?>> RANGED_INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.field_200741_ag).add((Object)EntityType.field_200750_ap).build();

    @Override
    public void setupBlock(IWorld world, BlockState state, BlockPos pos, Random rand, int stage) {
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof MobSpawnerTileEntity) {
            MobSpawnerTileEntity tile = (MobSpawnerTileEntity)tileentity;
            EntityType<?> type = Spawner.getRandomEntityType(rand);
            tile.func_145881_a().func_200876_a(type);
            if (INVENTORY_ENTITIES.contains(type)) {
                CompoundNBT spawnerNBT = tile.func_145881_a().func_189530_b(new CompoundNBT());
                ListNBT potentialSpawns = new ListNBT();
                for (int i = 0; i < (Integer)Config.SPAWNER_ENTITIES.get(); ++i) {
                    CompoundNBT nbt = new CompoundNBT();
                    CompoundNBT spawnData = new CompoundNBT();
                    spawnData.func_74778_a("id", type.getRegistryName().toString());
                    ItemStack[] armor = Spawner.getArmor(rand, stage);
                    ListNBT armorList = new ListNBT();
                    for (ItemStack stack : armor) {
                        armorList.add((Object)stack.func_77955_b(new CompoundNBT()));
                    }
                    spawnData.func_218657_a("ArmorItems", (INBT)armorList);
                    ListNBT handItems = new ListNBT();
                    ItemStack mainHand = RANGED_INVENTORY_ENTITIES.contains(type) ? RandomEquipment.getRangedWeapon(new Random(), stage) : RandomEquipment.getMeleeWeapon(new Random(), stage);
                    handItems.add((Object)mainHand.func_77955_b(new CompoundNBT()));
                    handItems.add((Object)ItemStack.field_190927_a.func_77955_b(new CompoundNBT()));
                    spawnData.func_218657_a("HandItems", (INBT)handItems);
                    nbt.func_218657_a("Entity", (INBT)spawnData);
                    nbt.func_74768_a("Weight", 1);
                    if (i == 0) {
                        spawnerNBT.func_218657_a("SpawnData", (INBT)spawnData);
                    }
                    potentialSpawns.add((Object)nbt);
                }
                spawnerNBT.func_218657_a("SpawnPotentials", (INBT)potentialSpawns);
                tile.func_145881_a().func_98270_a(spawnerNBT);
            }
        } else {
            DungeonCrawl.LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    public static ItemStack[] getArmor(Random rand, int stage) {
        switch (stage) {
            case 0: {
                return RandomEquipment.ARMOR_1.roll(rand);
            }
            case 1: {
                return RandomEquipment.ARMOR_2.roll(rand);
            }
            case 2: {
                return RandomEquipment.ARMOR_3.roll(rand);
            }
        }
        return RandomEquipment.ARMOR_1.roll(rand);
    }

    public static EntityType<?> getRandomEntityType(Random rand) {
        return (double)rand.nextFloat() < 0.04 ? ENTITIES_RARE[rand.nextInt(ENTITIES_RARE.length)] : ENTITIES[rand.nextInt(ENTITIES.length)];
    }
}

