/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skiesclear;

import com.pokeskies.skiesclear.config.ClearConfig;
import com.pokeskies.skiesclear.config.clearables.Clearable;
import com.pokeskies.skiesclear.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\r\u00a2\u0006\u0004\b\u001a\u0010\u001bJ7\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\n2\u0016\u0010!\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030 \u0012\u0004\u0012\u00020\n0\u001fH\u0002\u00a2\u0006\u0004\b\"\u0010#R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010&R\u001e\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/pokeskies/skiesclear/ClearTask;", "", "Lcom/pokeskies/skiesclear/config/ClearConfig;", "clearConfig", "<init>", "(Lcom/pokeskies/skiesclear/config/ClearConfig;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "broadcast", "", "runClear", "(Lnet/minecraft/server/MinecraftServer;Z)I", "", "tick", "(Lnet/minecraft/server/MinecraftServer;)V", "", "Lnet/minecraft/class_3218;", "getLevels", "(Lnet/minecraft/server/MinecraftServer;)Ljava/util/List;", "Lnet/minecraft/class_3222;", "player", "shouldInform", "(Lnet/minecraft/class_3222;)Z", "getTimer", "()I", "resetTimer", "()V", "", "string", "total", "", "Lcom/pokeskies/skiesclear/config/clearables/Clearable;", "cleared", "parsePlaceholders", "(Ljava/lang/String;ILjava/util/Map;)Ljava/lang/String;", "Lcom/pokeskies/skiesclear/config/ClearConfig;", "getClearConfig", "()Lcom/pokeskies/skiesclear/config/ClearConfig;", "dimensions", "Ljava/util/List;", "timer", "I", "SkiesClear"})
@SourceDebugExtension(value={"SMAP\nClearTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClearTask.kt\ncom/pokeskies/skiesclear/ClearTask\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n126#2:116\n153#2,3:117\n216#2,2:129\n774#3:120\n865#3,2:121\n774#3:123\n865#3,2:124\n774#3:126\n865#3,2:127\n*S KotlinDebug\n*F\n+ 1 ClearTask.kt\ncom/pokeskies/skiesclear/ClearTask\n*L\n21#1:116\n21#1:117,3\n108#1:129,2\n27#1:120\n27#1:121,2\n47#1:123\n47#1:124,2\n62#1:126\n62#1:127,2\n*E\n"})
public final class ClearTask {
    @NotNull
    private final ClearConfig clearConfig;
    @Nullable
    private List<? extends class_3218> dimensions;
    private int timer;

    public ClearTask(@NotNull ClearConfig clearConfig) {
        Intrinsics.checkNotNullParameter((Object)clearConfig, (String)"clearConfig");
        this.clearConfig = clearConfig;
        this.timer = this.clearConfig.getInterval();
    }

    @NotNull
    public final ClearConfig getClearConfig() {
        return this.clearConfig;
    }

    /*
     * WARNING - void declaration
     */
    public final int runClear(@NotNull MinecraftServer server, boolean broadcast) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        List<class_3218> levels = this.getLevels(server);
        Map<String, Clearable<?>> $this$map$iv = this.clearConfig.getClearables();
        boolean $i$f$map = false;
        Map<String, Clearable<?>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            Map.Entry entry = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String id = (String)entry.getKey();
            Clearable clearable = (Clearable)entry.getValue();
            collection.add(TuplesKt.to((Object)clearable, (Object)clearable.clearEntities(this.clearConfig, levels)));
        }
        Map totals = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        int total = CollectionsKt.sumOfInt((Iterable)totals.values());
        if (broadcast && (!((Collection)this.clearConfig.getMessages().getClear()).isEmpty() || this.clearConfig.getSounds().getClear() != null)) {
            void $this$filterTo$iv$iv;
            List list = server.method_3760().method_14571();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable $i$f$mapTo2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                class_3222 it = (class_3222)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.shouldInform(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (class_3222 player : (List)destination$iv$iv2) {
                for (String line : this.clearConfig.getMessages().getClear()) {
                    player.method_43496(Utils.INSTANCE.deserializeText(this.parsePlaceholders(line, total, totals)));
                }
                if (this.clearConfig.getSounds().getClear() == null || !(((CharSequence)this.clearConfig.getSounds().getClear().getSound()).length() > 0)) continue;
                player.method_17356(class_3414.method_47908((class_2960)class_2960.method_60654((String)this.clearConfig.getSounds().getClear().getSound())), class_3419.field_15250, this.clearConfig.getSounds().getClear().getVolume(), this.clearConfig.getSounds().getClear().getPitch());
            }
        }
        return total;
    }

    /*
     * WARNING - void declaration
     */
    public final void tick(@NotNull MinecraftServer server) {
        ClearConfig.Sounds.SoundSettings warningSound;
        Object destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        List<String> warningMessage = this.clearConfig.getMessages().getWarnings().get(String.valueOf(this.timer));
        if (warningMessage != null) {
            void $this$filterTo$iv$iv;
            List list = server.method_3760().method_14571();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                class_3222 it = (class_3222)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.shouldInform(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (class_3222 player : (List)destination$iv$iv) {
                for (String line : warningMessage) {
                    destination$iv$iv = line;
                    Regex $i$f$filterTo2 = new Regex("%time_remaining%");
                    String string = Utils.INSTANCE.getFormattedTime(this.timer);
                    player.method_43496(Utils.INSTANCE.deserializeText($i$f$filterTo2.replace((CharSequence)destination$iv$iv, string)));
                }
            }
        }
        if ((warningSound = this.clearConfig.getSounds().getWarnings().get(String.valueOf(this.timer))) != null && ((CharSequence)warningSound.getSound()).length() > 0) {
            void $this$filterTo$iv$iv;
            List list = server.method_3760().method_14571();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                class_3222 it = (class_3222)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.shouldInform(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (class_3222 player : (List)destination$iv$iv2) {
                player.method_17356(class_3414.method_47908((class_2960)class_2960.method_60654((String)warningSound.getSound())), class_3419.field_15250, warningSound.getVolume(), warningSound.getPitch());
            }
        }
        int n = this.timer;
        this.timer = n + -1;
        if (n <= 0) {
            this.resetTimer();
            this.runClear(server, true);
        }
    }

    private final List<class_3218> getLevels(MinecraftServer server) {
        if (this.dimensions != null) {
            List<class_3218> list = this.dimensions;
            Intrinsics.checkNotNull(list);
            return list;
        }
        List newDimensions = new ArrayList();
        for (class_3218 level : server.method_3738()) {
            if (!this.clearConfig.getDimensions().contains(level.method_27983().method_29177().toString())) continue;
            Intrinsics.checkNotNull((Object)level);
            newDimensions.add(level);
        }
        if (newDimensions.isEmpty()) {
            Iterable iterable = server.method_3738();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
            newDimensions = CollectionsKt.toMutableList((Iterable)iterable);
        }
        this.dimensions = newDimensions;
        return newDimensions;
    }

    private final boolean shouldInform(class_3222 player) {
        return !this.clearConfig.getInformDimensionsOnly() || this.clearConfig.getDimensions().isEmpty() || this.clearConfig.getDimensions().contains(player.method_37908().method_27983().method_29177().toString());
    }

    public final int getTimer() {
        return this.timer;
    }

    public final void resetTimer() {
        this.timer = this.clearConfig.getInterval();
    }

    private final String parsePlaceholders(String string, int total, Map<Clearable<?>, Integer> cleared) {
        String parsed = null;
        CharSequence charSequence = string;
        Regex regex = new Regex("%clear_time%");
        Object object = Utils.INSTANCE.getFormattedTime(this.clearConfig.getInterval());
        charSequence = regex.replace(charSequence, (String)object);
        regex = new Regex("%clear_amount%");
        object = String.valueOf(total);
        parsed = regex.replace(charSequence, (String)object);
        Map<Clearable<?>, Integer> $this$forEach$iv = cleared;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            Clearable clearable = (Clearable)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            parsed = clearable.parse(parsed, amount);
        }
        return parsed;
    }
}

