/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skiesclear.config;

import com.google.gson.stream.JsonReader;
import com.pokeskies.skiesclear.SkiesClear;
import com.pokeskies.skiesclear.config.MainConfig;
import com.pokeskies.skiesclear.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u001f\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ;\u0010\u0013\u001a\u00028\u0000\"\b\b\u0000\u0010\r*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00028\u00002\b\b\u0002\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0016\u001a\u00020\u0011\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0019\u0010\fR\u0016\u0010\u001a\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/pokeskies/skiesclear/config/ConfigManager;", "", "<init>", "()V", "", "load", "copyDefaults", "Ljava/lang/ClassLoader;", "classLoader", "", "fileName", "attemptDefaultFileCopy", "(Ljava/lang/ClassLoader;Ljava/lang/String;)V", "T", "filename", "default", "path", "", "create", "loadFile", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Z)Ljava/lang/Object;", "object", "saveFile", "(Ljava/lang/String;Ljava/lang/Object;)Z", "directoryName", "attemptDefaultDirectoryCopy", "assetPackage", "Ljava/lang/String;", "Lcom/pokeskies/skiesclear/config/MainConfig;", "CONFIG", "Lcom/pokeskies/skiesclear/config/MainConfig;", "getCONFIG", "()Lcom/pokeskies/skiesclear/config/MainConfig;", "setCONFIG", "(Lcom/pokeskies/skiesclear/config/MainConfig;)V", "SkiesClear"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    private static String assetPackage = "assets/skiesclear";
    public static MainConfig CONFIG;

    private ConfigManager() {
    }

    @NotNull
    public final MainConfig getCONFIG() {
        MainConfig mainConfig = CONFIG;
        if (mainConfig != null) {
            return mainConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"CONFIG");
        return null;
    }

    public final void setCONFIG(@NotNull MainConfig mainConfig) {
        Intrinsics.checkNotNullParameter((Object)mainConfig, (String)"<set-?>");
        CONFIG = mainConfig;
    }

    public final void load() {
        this.copyDefaults();
        this.setCONFIG((MainConfig)ConfigManager.loadFile$default(this, "config.json", new MainConfig(false, null, 3, null), null, false, 12, null));
    }

    private final void copyDefaults() {
        ClassLoader classLoader = SkiesClear.class.getClassLoader();
        SkiesClear.Companion.getINSTANCE().getConfigDir().mkdirs();
        Intrinsics.checkNotNull((Object)classLoader);
        this.attemptDefaultFileCopy(classLoader, "config.json");
    }

    private final void attemptDefaultFileCopy(ClassLoader classLoader, String fileName) {
        File file = FilesKt.resolve((File)SkiesClear.Companion.getINSTANCE().getConfigDir(), (String)fileName);
        if (!file.exists()) {
            file.mkdirs();
            try {
                InputStream inputStream = classLoader.getResourceAsStream(assetPackage + "/" + fileName);
                if (inputStream == null) {
                    throw new NullPointerException("File not found " + fileName);
                }
                InputStream stream = inputStream;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(stream, file.toPath(), copyOptionArray);
            }
            catch (Exception e) {
                Utils.INSTANCE.printError("Failed to copy the default file '" + fileName + "': " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T loadFile(@NotNull String filename, @NotNull T t, @NotNull String path, boolean create) {
        Object value;
        block14: {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter(t, (String)"default");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File dir = SkiesClear.Companion.getINSTANCE().getConfigDir();
            if (((CharSequence)path).length() > 0) {
                dir = FilesKt.resolve((File)dir, (String)path);
            }
            File file = new File(dir, filename);
            value = null;
            value = t;
            try {
                Files.createDirectories(SkiesClear.Companion.getINSTANCE().getConfigDir().toPath(), new FileAttribute[0]);
                if (file.exists()) {
                    Closeable closeable = new FileReader(file);
                    Throwable throwable = null;
                    try {
                        FileReader reader = (FileReader)closeable;
                        boolean bl = false;
                        JsonReader jsonReader = new JsonReader((Reader)reader);
                        Object object = SkiesClear.Companion.getINSTANCE().getGsonPretty().fromJson(jsonReader, (Type)t.getClass());
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                        value = object;
                        reader = Unit.INSTANCE;
                        break block14;
                    }
                    catch (Throwable bl) {
                        throwable = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                if (!create) break block14;
                Files.createFile(file.toPath(), new FileAttribute[0]);
                Closeable closeable = new FileWriter(file);
                Throwable throwable = null;
                try {
                    FileWriter fileWriter = (FileWriter)closeable;
                    boolean bl = false;
                    fileWriter.write(SkiesClear.Companion.getINSTANCE().getGsonPretty().toJson(t));
                    fileWriter.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (T)value;
    }

    public static /* synthetic */ Object loadFile$default(ConfigManager configManager, String string, Object object, String string2, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return configManager.loadFile(string, object, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> boolean saveFile(@NotNull String filename, T object) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        File dir = SkiesClear.Companion.getINSTANCE().getConfigDir();
        File file = new File(dir, filename);
        try {
            Closeable closeable = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter fileWriter = (FileWriter)closeable;
                boolean bl = false;
                fileWriter.write(SkiesClear.Companion.getINSTANCE().getGsonPretty().toJson(object));
                fileWriter.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void attemptDefaultDirectoryCopy(ClassLoader classLoader, String directoryName) {
        File directory = FilesKt.resolve((File)SkiesClear.Companion.getINSTANCE().getConfigDir(), (String)directoryName);
        if (!directory.exists()) {
            directory.mkdirs();
            try {
                URL uRL = classLoader.getResource(assetPackage + "/" + directoryName);
                if (uRL == null) {
                    throw new NullPointerException("Directory not found " + directoryName);
                }
                URL sourceUrl = uRL;
                Path sourcePath = Paths.get(sourceUrl.toURI());
                AutoCloseable autoCloseable = Files.walk(sourcePath, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    Stream stream = (Stream)autoCloseable;
                    boolean bl = false;
                    stream.forEach(arg_0 -> ConfigManager.attemptDefaultDirectoryCopy$lambda$5$lambda$4(arg_0 -> ConfigManager.attemptDefaultDirectoryCopy$lambda$5$lambda$3(directory, sourcePath, arg_0), arg_0));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                Utils.INSTANCE.printError("Failed to copy the default directory '" + directoryName + "': " + e.getMessage());
            }
        }
    }

    private static final Unit attemptDefaultDirectoryCopy$lambda$5$lambda$3(File $directory, Path $sourcePath, Path sourceFile) {
        File destinationFile = FilesKt.resolve((File)$directory, (String)((Object)$sourcePath.relativize(sourceFile)).toString());
        if (Files.isDirectory(sourceFile, new LinkOption[0])) {
            v0 = Boolean.valueOf(destinationFile.mkdirs());
        } else {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            v0 = Files.copy(sourceFile, destinationFile.toPath(), copyOptionArray);
        }
        return Unit.INSTANCE;
    }

    private static final void attemptDefaultDirectoryCopy$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

