/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skiesclear.config.clearables;

import com.pokeskies.skiesclear.SkiesClear;
import com.pokeskies.skiesclear.config.ClearConfig;
import com.pokeskies.skiesclear.config.clearables.Clearable;
import com.pokeskies.skiesclear.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_2105;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5575;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bJ#\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ#\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0004\b!\u0010\u001fJ\u000f\u0010\"\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b$\u0010#R\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\u00058\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b(\u0010&R\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020 0\u00058\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b)\u0010&\u00a8\u0006*"}, d2={"Lcom/pokeskies/skiesclear/config/clearables/EntityClearable;", "Lcom/pokeskies/skiesclear/config/clearables/Clearable;", "Lnet/minecraft/class_1297;", "", "enabled", "", "", "blacklist", "whitelist", "<init>", "(ZLjava/util/List;Ljava/util/List;)V", "", "initialize", "()V", "entity", "Lnet/minecraft/class_2960;", "getResourceLocation", "(Lnet/minecraft/class_1297;)Lnet/minecraft/class_2960;", "Lcom/pokeskies/skiesclear/config/ClearConfig;", "clearConfig", "Lnet/minecraft/class_3218;", "levels", "", "clearEntities", "(Lcom/pokeskies/skiesclear/config/ClearConfig;Ljava/util/List;)I", "id", "isBlacklisted", "(Lnet/minecraft/class_1297;Lnet/minecraft/class_2960;)Z", "isWhitelisted", "list", "generateTags", "(Ljava/util/List;)Ljava/util/List;", "Lnet/minecraft/class_2487;", "generateNBT", "getPlaceholder", "()Ljava/lang/String;", "toString", "blacklistedTags", "Ljava/util/List;", "blacklistedNbt", "whitelistedTags", "whitelistedNbt", "SkiesClear"})
@SourceDebugExtension(value={"SMAP\nEntityClearable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityClearable.kt\ncom/pokeskies/skiesclear/config/clearables/EntityClearable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n774#2:170\n865#2,2:171\n1869#2,2:173\n1869#2,2:175\n1869#2,2:177\n*S KotlinDebug\n*F\n+ 1 EntityClearable.kt\ncom/pokeskies/skiesclear/config/clearables/EntityClearable\n*L\n46#1:170\n46#1:171,2\n53#1:173,2\n78#1:175,2\n114#1:177,2\n*E\n"})
public final class EntityClearable
extends Clearable<class_1297> {
    private transient List<String> blacklistedTags;
    private transient List<? extends class_2487> blacklistedNbt;
    private transient List<String> whitelistedTags;
    private transient List<? extends class_2487> whitelistedNbt;

    public EntityClearable(boolean enabled, @NotNull List<String> blacklist, @NotNull List<String> whitelist) {
        Intrinsics.checkNotNullParameter(blacklist, (String)"blacklist");
        Intrinsics.checkNotNullParameter(whitelist, (String)"whitelist");
        super(enabled, blacklist, whitelist);
    }

    public /* synthetic */ EntityClearable(boolean bl, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(bl, list, list2);
    }

    @Override
    public void initialize() {
        this.blacklistedTags = this.generateTags(this.getBlacklist());
        this.whitelistedTags = this.generateTags(this.getWhitelist());
        this.blacklistedNbt = this.generateNBT(this.getBlacklist());
        this.whitelistedNbt = this.generateNBT(this.getWhitelist());
    }

    @Override
    @NotNull
    public class_2960 getResourceLocation(@NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        class_2960 class_29602 = class_7923.field_41177.method_10221((Object)entity.method_5864());
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getKey(...)");
        return class_29602;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int clearEntities(@NotNull ClearConfig clearConfig, @NotNull List<? extends class_3218> levels) {
        Intrinsics.checkNotNullParameter((Object)clearConfig, (String)"clearConfig");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        if (!this.getEnabled()) {
            return 0;
        }
        int removalCount = 0;
        for (class_3218 class_32182 : levels) {
            try {
                void $this$filterTo$iv$iv;
                List list = class_32182.method_18198(class_5575.method_31795(class_1297.class), arg_0 -> EntityClearable.clearEntities$lambda$1(EntityClearable::clearEntities$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    class_1297 entity = (class_1297)element$iv$iv;
                    boolean bl2 = false;
                    if (entity instanceof class_1657) {
                        bl = false;
                    } else if (entity instanceof class_1308 && ((class_1308)entity).method_5947() && !clearConfig.getClearPersistent()) {
                        bl = false;
                    } else if (entity.method_16914() && !clearConfig.getClearNamed()) {
                        bl = false;
                    } else if (entity.method_5765() && !clearConfig.getClearPassengers()) {
                        bl = false;
                    } else {
                        Intrinsics.checkNotNull((Object)entity);
                        bl = this.shouldClear(entity);
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List entities = (List)destination$iv$iv;
                Iterable $this$forEach$iv = entities;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_1297 entity = (class_1297)element$iv;
                    boolean bl = false;
                    entity.method_5650(class_1297.class_5529.field_26998);
                }
                removalCount += entities.size();
            }
            catch (Exception exception) {
                Utils.INSTANCE.printError("An exception was thrown while attempting to clear entities: + " + exception);
                exception.printStackTrace();
            }
        }
        return removalCount;
    }

    @Override
    public boolean isBlacklisted(@NotNull class_1297 entity, @NotNull class_2960 id) {
        List<? extends class_2487> list;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<String> list2 = this.blacklistedTags;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blacklistedTags");
            list2 = null;
        }
        if (!((Collection)list2).isEmpty()) {
            Set set = entity.method_5752();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTags(...)");
            if (!((Collection)set).isEmpty() && entity.method_5752().stream().anyMatch(arg_0 -> EntityClearable.isBlacklisted$lambda$5(arg_0 -> EntityClearable.isBlacklisted$lambda$4(this, arg_0), arg_0))) {
                return true;
            }
        }
        if ((list = this.blacklistedNbt) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blacklistedNbt");
            list = null;
        }
        if (!((Collection)list).isEmpty()) {
            class_2487 nbt = class_2105.method_9076((class_1297)entity);
            boolean passes = false;
            List<? extends class_2487> list3 = this.blacklistedNbt;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"blacklistedNbt");
                list3 = null;
            }
            for (class_2487 class_24872 : list3) {
                if (passes) break;
                Set set = class_24872.method_10541();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllKeys(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_2520 entityTag;
                    class_2520 tag;
                    String key = (String)element$iv;
                    boolean bl = false;
                    if (!nbt.method_10545(key) || !Intrinsics.areEqual((Object)(tag = class_24872.method_10580(key)), (Object)(entityTag = nbt.method_10580(key)))) continue;
                    passes = true;
                }
            }
            if (passes) {
                return true;
            }
        }
        return super.isBlacklisted(entity, id);
    }

    @Override
    public boolean isWhitelisted(@NotNull class_1297 entity, @NotNull class_2960 id) {
        List<? extends class_2487> list;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<String> list2 = this.whitelistedTags;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"whitelistedTags");
            list2 = null;
        }
        if (!((Collection)list2).isEmpty()) {
            Set set = entity.method_5752();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTags(...)");
            if (!((Collection)set).isEmpty() && entity.method_5752().stream().anyMatch(arg_0 -> EntityClearable.isWhitelisted$lambda$8(arg_0 -> EntityClearable.isWhitelisted$lambda$7(this, arg_0), arg_0))) {
                return true;
            }
        }
        if ((list = this.whitelistedNbt) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"whitelistedNbt");
            list = null;
        }
        if (!((Collection)list).isEmpty()) {
            class_2487 nbt = class_2105.method_9076((class_1297)entity);
            boolean passes = false;
            List<? extends class_2487> list3 = this.whitelistedNbt;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"whitelistedNbt");
                list3 = null;
            }
            for (class_2487 class_24872 : list3) {
                if (passes) break;
                Set set = class_24872.method_10541();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllKeys(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_2520 entityTag;
                    class_2520 tag;
                    String key = (String)element$iv;
                    boolean bl = false;
                    if (!nbt.method_10545(key) || !Intrinsics.areEqual((Object)(tag = class_24872.method_10580(key)), (Object)(entityTag = nbt.method_10580(key)))) continue;
                    passes = true;
                }
            }
            if (passes) {
                return true;
            }
        }
        return super.isWhitelisted(entity, id);
    }

    private final List<String> generateTags(List<String> list) {
        List newTags = new ArrayList();
        for (String entry : list) {
            if (!StringsKt.startsWith((String)entry, (String)"#tag=", (boolean)true)) continue;
            String[] stringArray = new String[]{"="};
            List split = StringsKt.split((CharSequence)entry, (String[])stringArray, (boolean)true, (int)2);
            if (split.size() != 2) continue;
            newTags.add(split.get(1));
        }
        return newTags;
    }

    private final List<class_2487> generateNBT(List<String> list) {
        List newTags = new ArrayList();
        for (String entry : list) {
            if (!StringsKt.startsWith((String)entry, (String)"#nbt=", (boolean)true)) continue;
            String[] stringArray = new String[]{"="};
            List split = StringsKt.split((CharSequence)entry, (String[])stringArray, (boolean)true, (int)2);
            if (split.size() != 2) continue;
            Object object = SkiesClear.Companion.getINSTANCE().getGson().fromJson((String)split.get(1), class_2487.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            newTags.add(object);
        }
        return newTags;
    }

    @Override
    @NotNull
    public String getPlaceholder() {
        return "%clear_amount_entities%";
    }

    @NotNull
    public String toString() {
        return "EntityClearable(enabled=" + this.getEnabled() + ", blacklist=" + this.getBlacklist() + ", whitelist=" + this.getWhitelist() + ")";
    }

    private static final boolean clearEntities$lambda$0(class_1297 it) {
        return true;
    }

    private static final boolean clearEntities$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isBlacklisted$lambda$4(EntityClearable this$0, String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<String> list = this$0.blacklistedTags;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blacklistedTags");
            list = null;
        }
        return list.contains(tag);
    }

    private static final boolean isBlacklisted$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isWhitelisted$lambda$7(EntityClearable this$0, String pokemonTag) {
        Intrinsics.checkNotNullParameter((Object)pokemonTag, (String)"pokemonTag");
        List<String> list = this$0.whitelistedTags;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"whitelistedTags");
            list = null;
        }
        return list.contains(pokemonTag);
    }

    private static final boolean isWhitelisted$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public EntityClearable() {
        this(false, null, null, 7, null);
    }
}

