/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cradlebypar.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.cradlebypar.CradleByParMod;
import net.mcreator.cradlebypar.procedures.VenomStrikeInfoGUIBackbuttonProcedure;
import net.mcreator.cradlebypar.procedures.VenomStrikeNextButtonGUIProcedure;
import net.mcreator.cradlebypar.world.inventory.VenomStrikeInfoGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VenomStrikeInfoGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public VenomStrikeInfoGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public VenomStrikeInfoGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(VenomStrikeInfoGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(VenomStrikeInfoGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            VenomStrikeInfoGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = VenomStrikeInfoGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            VenomStrikeInfoGUIBackbuttonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            VenomStrikeNextButtonGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CradleByParMod.addNetworkMessage(VenomStrikeInfoGUIButtonMessage.class, VenomStrikeInfoGUIButtonMessage::buffer, VenomStrikeInfoGUIButtonMessage::new, VenomStrikeInfoGUIButtonMessage::handler);
    }
}

