/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.mixin;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class MixinEntityTeleport {
    @Shadow
    @Nullable
    protected class_2338 field_5991;

    @Shadow
    public abstract class_1937 method_37908();

    @Shadow
    public abstract double method_23317();

    @Shadow
    public abstract double method_23318();

    @Shadow
    public abstract double method_23321();

    @Shadow
    public abstract class_243 method_18798();

    @Shadow
    public abstract float method_36454();

    @Shadow
    public abstract float method_36455();

    @Shadow
    protected abstract Optional<class_5459.class_5460> method_30330(class_3218 var1, class_2338 var2, boolean var3, class_2784 var4);

    @Shadow
    protected abstract class_243 method_30633(class_2350.class_2351 var1, class_5459.class_5460 var2);

    @Inject(method={"getTeleportTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void patchPortalScaling(class_3218 destination, CallbackInfoReturnable<class_5454> cir) {
        Optional<class_5459.class_5460> destRectOpt;
        class_2338 probePos;
        boolean fromNether;
        class_1937 currentWorld = this.method_37908();
        class_5321 currentKey = currentWorld.method_27983();
        class_5321 destKey = destination.method_27983();
        boolean toNether = destKey == class_1937.field_25180;
        boolean bl = fromNether = currentKey == class_1937.field_25180;
        if (!toNether && !fromNether) {
            return;
        }
        class_2784 destBorder = destination.method_8621();
        class_2338 entityPos = class_2338.method_49637((double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321());
        class_2338 bestPortalPos = null;
        double closestDistance = Double.MAX_VALUE;
        int range = 1;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    double dist;
                    class_2338 checkPos = entityPos.method_10069(x, y, z);
                    if (!currentWorld.method_8320(checkPos).method_27852(class_2246.field_10316) || !((dist = checkPos.method_10262((class_2382)entityPos)) < closestDistance)) continue;
                    closestDistance = dist;
                    bestPortalPos = checkPos;
                }
            }
        }
        class_2338 class_23382 = probePos = bestPortalPos != null ? bestPortalPos : entityPos;
        if (!(currentWorld instanceof class_3218)) {
            return;
        }
        class_3218 currentServer = (class_3218)currentWorld;
        Optional<class_5459.class_5460> srcRectOpt = this.method_30330(currentServer, probePos, fromNether, currentServer.method_8621());
        if (srcRectOpt.isEmpty()) {
            return;
        }
        class_5459.class_5460 srcRect = srcRectOpt.get();
        class_2338 srcLowerLeft = srcRect.field_25936;
        int srcWidth = srcRect.field_25937;
        int srcHeight = srcRect.field_25938;
        class_2680 srcState = currentWorld.method_8320(srcLowerLeft);
        class_2350.class_2351 srcAxis = srcState.method_28498((class_2769)class_2741.field_12529) ? (class_2350.class_2351)srcState.method_11654((class_2769)class_2741.field_12529) : class_2350.class_2351.field_11048;
        class_2338 destAnchor = new class_2338(srcLowerLeft.method_10263(), srcRect.field_25936.method_10264() - 1, srcLowerLeft.method_10260());
        class_2338 foundPortal = MixinEntityTeleport.findExistingPortal(destination, destAnchor);
        if (foundPortal != null && !destination.method_8320(foundPortal).method_27852(class_2246.field_10316)) {
            foundPortal = null;
        }
        if (foundPortal == null) {
            MixinEntityTeleport.createNewPortalAt(destination, destAnchor, srcAxis, srcWidth, srcHeight);
            foundPortal = destAnchor;
        }
        if ((destRectOpt = this.method_30330(destination, foundPortal, toNether, destBorder)).isEmpty()) {
            return;
        }
        class_5459.class_5460 destRect = destRectOpt.get();
        class_2680 destState = destination.method_8320(foundPortal);
        class_2350.class_2351 destAxis = destState.method_28498((class_2769)class_2741.field_12529) ? (class_2350.class_2351)destState.method_11654((class_2769)class_2741.field_12529) : srcAxis;
        class_243 offset = this.method_30633(destAxis, destRect);
        class_5454 target = class_2424.method_30484((class_3218)destination, (class_5459.class_5460)destRect, (class_2350.class_2351)destAxis, (class_243)offset, (class_1297)((class_1297)this), (class_243)this.method_18798(), (float)this.method_36454(), (float)this.method_36455());
        cir.setReturnValue((Object)target);
        cir.cancel();
    }

    @Unique
    @Nullable
    private static class_2338 findExistingPortal(class_3218 world, class_2338 basePos) {
        class_2338 pos;
        int y;
        int x = basePos.method_10263();
        int z = basePos.method_10260();
        for (y = basePos.method_10264(); y < world.method_31600(); ++y) {
            pos = new class_2338(x, y, z);
            if (!world.method_8320(pos).method_27852(class_2246.field_10316)) continue;
            return pos;
        }
        for (y = basePos.method_10264() - 1; y >= world.method_31607(); --y) {
            pos = new class_2338(x, y, z);
            if (!world.method_8320(pos).method_27852(class_2246.field_10316)) continue;
            return pos;
        }
        return null;
    }

    @Unique
    private static void createNewPortalAt(class_3218 world, class_2338 baseLowerLeftInterior, class_2350.class_2351 axis, int width, int height) {
        class_2350 right = axis == class_2350.class_2351.field_11048 ? class_2350.field_11034 : class_2350.field_11035;
        int frameWidth = width + 2;
        int frameHeight = height + 2;
        for (int y = 0; y < frameHeight; ++y) {
            for (int x = 0; x < frameWidth; ++x) {
                boolean isFrame;
                class_2338 pos = baseLowerLeftInterior.method_10079(right, x - 1).method_10086(y);
                boolean bl = isFrame = x == 0 || x == frameWidth - 1 || y == 0 || y == frameHeight - 1;
                if (isFrame) {
                    world.method_8652(pos, class_2246.field_10540.method_9564(), 18);
                    continue;
                }
                world.method_8652(pos, (class_2680)class_2246.field_10316.method_9564().method_11657((class_2769)class_2741.field_12529, (Comparable)axis), 18);
            }
        }
        System.out.println("[Portal] Created new portal copy at " + String.valueOf(baseLowerLeftInterior) + " axis=" + String.valueOf(axis) + " size=" + width + "x" + height);
    }
}

