/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.protectmyvillager.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.kop.protectmyvillager.config.ModOptions;
import dev.kop.protectmyvillager.utils.LoggerUtil;
import dev.kop.protectmyvillager.utils.ModInfoUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String modid = ModInfoUtil.getModId();
    public static final ModConfig INSTANCE = new ModConfig(FabricLoader.getInstance().getConfigDir().resolve(modid + ".json").toFile());
    protected final File file;
    protected final Object2ObjectLinkedOpenHashMap<String, ModOptions<?>> optionMap = new Object2ObjectLinkedOpenHashMap();
    public final ModOptions.BooleanOption includeZombieVillagers = this.addOption(new ModOptions.BooleanOption("include_zombie_villagers", false));
    public final ModOptions.BooleanOption includeWanderingTraders = this.addOption(new ModOptions.BooleanOption("include_wandering_traders", false));
    public final ModOptions.BooleanOption removeHandSwing = this.addOption(new ModOptions.BooleanOption("remove_hand_swing", false));

    public ModConfig(File file) {
        this.file = file;
    }

    public void load() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                this.fromJson(JsonParser.parseReader((Reader)reader));
            }
            catch (Exception e) {
                LoggerUtil.error("Could not load config from file '" + this.file.getAbsolutePath() + "'" + String.valueOf(e));
            }
        }
        this.save();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson(this.toJson(), (Appendable)writer);
        }
        catch (Exception e) {
            LoggerUtil.error("Could not save config to file '" + this.file.getAbsolutePath() + "'" + String.valueOf(e));
        }
    }

    protected void fromJson(JsonElement json) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
                JsonElement element = object.get((String)entry.getKey());
                if (element == null) continue;
                try {
                    ((ModOptions)entry.getValue()).fromJson(element);
                }
                catch (JsonParseException e) {
                    LoggerUtil.error("Could not read option '" + (String)entry.getKey() + "'" + String.valueOf((Object)e));
                }
            }
        } else {
            throw new JsonParseException("Json must be an object");
        }
    }

    protected JsonElement toJson() {
        JsonObject object = new JsonObject();
        ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
            object.add((String)entry.getKey(), ((ModOptions)entry.getValue()).toJson());
        }
        return object;
    }

    protected <T extends ModOptions<?>> T addOption(T option) {
        ModOptions old = (ModOptions)this.optionMap.put((Object)option.getKey(), option);
        if (old != null) {
            LoggerUtil.warn("Option with key=" + old.getKey() + " was overridden");
        }
        return option;
    }

    static {
        INSTANCE.load();
    }
}

