/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.protectmyvillager.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;

public interface ModOptions<T> {
    public String getKey();

    public T get();

    public void set(T var1);

    public JsonElement toJson();

    public void fromJson(JsonElement var1) throws JsonParseException;

    public static class BooleanOption
    extends BaseOption<Boolean> {
        public BooleanOption(String key, Boolean defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive((Boolean)this.get());
        }

        @Override
        public void fromJson(JsonElement json) throws JsonParseException {
            if (!json.isJsonPrimitive()) {
                throw new JsonParseException("JSON must be a primitive");
            }
            this.set(json.getAsBoolean());
        }
    }

    public static abstract class BaseOption<T>
    implements ModOptions<T> {
        protected final String key;
        protected T value;

        public BaseOption(String key, T defaultValue) {
            this.key = key;
            this.value = defaultValue;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void set(T value) {
            this.value = value;
        }
    }
}

