/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.protectmyvillager.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.numbits.protectmyvillager.config.ModOptions;
import dev.numbits.protectmyvillager.utils.LoggerUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

public class ModConfig {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ModConfig INSTANCE = new ModConfig(FabricLoader.getInstance().getConfigDir().resolve("protectmyvillager.json").toFile());
    protected final File file;
    protected final Object2ObjectLinkedOpenHashMap<String, ModOptions<?>> optionMap = new Object2ObjectLinkedOpenHashMap();
    protected final Map<String, ModOptions<?>> optionMapView = Collections.unmodifiableMap(this.optionMap);
    public final ModOptions.BooleanOption includeZombieVillagers = this.addOption(new ModOptions.BooleanOption("include_zombie_villagers", false));
    public final ModOptions.BooleanOption includeWanderingTraders = this.addOption(new ModOptions.BooleanOption("include_wandering_traders", false));

    public ModConfig(File file) {
        this.file = file;
    }

    public void load() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                this.fromJson(JsonParser.parseReader((Reader)reader));
            }
            catch (Exception e) {
                LoggerUtils.error("Could not load config from file '" + this.file.getAbsolutePath() + "'" + String.valueOf(e));
            }
        }
        this.save();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson(this.toJson(), (Appendable)writer);
        }
        catch (Exception e) {
            LoggerUtils.error("Could not save config to file '" + this.file.getAbsolutePath() + "'" + String.valueOf(e));
        }
    }

    protected void fromJson(JsonElement json) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
                JsonElement element = object.get((String)entry.getKey());
                if (element == null) continue;
                try {
                    ((ModOptions)entry.getValue()).fromJson(element);
                }
                catch (JsonParseException e) {
                    LoggerUtils.error("Could not read option '" + (String)entry.getKey() + "'" + String.valueOf((Object)e));
                }
            }
        } else {
            throw new JsonParseException("Json must be an object");
        }
    }

    protected JsonElement toJson() {
        JsonObject object = new JsonObject();
        ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
            object.add((String)entry.getKey(), ((ModOptions)entry.getValue()).toJson());
        }
        return object;
    }

    protected <T extends ModOptions<?>> T addOption(T option) {
        ModOptions old = (ModOptions)this.optionMap.put((Object)option.getKey(), option);
        if (old != null) {
            LoggerUtils.warn("Option with key=" + old.getKey() + " was overridden");
        }
        return option;
    }

    @Nullable
    public ModOptions<?> getOption(String key) {
        return (ModOptions)this.optionMap.get((Object)key);
    }

    public Map<String, ModOptions<?>> getOptionMapView() {
        return this.optionMapView;
    }

    static {
        INSTANCE.load();
    }
}

