/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.api.v1.dev;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerHelper
implements InvocationHandler {
    private final Logger delegate;
    private final String prefix;

    private LoggerHelper(Logger delegate, String prefix) {
        this.delegate = delegate;
        this.prefix = prefix;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ((methodName.equals("debug") || methodName.equals("info") || methodName.equals("warn") || methodName.equals("error") || methodName.equals("trace")) && args != null && args.length > 0 && args[0] instanceof String) {
            args[0] = "[" + this.prefix + "] " + String.valueOf(args[0]);
        }
        return method.invoke((Object)this.delegate, args);
    }

    public static Logger createLogger(String prefix) {
        Logger originalLogger = LoggerFactory.getLogger((String)prefix);
        return (Logger)Proxy.newProxyInstance(originalLogger.getClass().getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new LoggerHelper(originalLogger, prefix));
    }
}

