/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.Compare;

public class ItemTagRegistry {
    private static final List<String> BASE_PATHS = new ArrayList<String>();
    private static final Map<String, List<Item>> TYPE_TO_ITEMS_MAP = new HashMap<String, List<Item>>();

    public static void add(String path) {
        BASE_PATHS.add(path);
    }

    public static void loadAllItemTags() {
        TYPE_TO_ITEMS_MAP.clear();
        try {
            for (String basePath : BASE_PATHS) {
                Minecraft.getInstance().getResourceManager().listResources(basePath, path -> path.toString().endsWith(".json")).forEach((location, resource) -> {
                    try {
                        InputStreamReader reader = new InputStreamReader(resource.open());
                        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        reader.close();
                        String type = basePath + ":" + json.get("type").getAsString();
                        JsonArray itemsArray = json.getAsJsonArray("items");
                        List<Item> itemList = ItemTagRegistry.parseItemsArray(itemsArray);
                        TYPE_TO_ITEMS_MAP.putIfAbsent(type, new ArrayList());
                        TYPE_TO_ITEMS_MAP.get(type).addAll(itemList);
                    }
                    catch (Exception e) {
                        Constants.LOG.error("Opps something went wrong!");
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e) {
            Constants.LOG.error("Opps something went wrong!");
            e.printStackTrace();
        }
    }

    private static List<Item> parseItemsArray(JsonArray itemsArray) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (JsonElement element : itemsArray) {
            String itemString = element.getAsString();
            if (itemString.startsWith("#")) {
                String tagId = itemString.substring(1);
                BuiltInRegistries.ITEM.stream().forEach(item -> {
                    if (Compare.isHasTag(item, tagId)) {
                        itemList.add((Item)item);
                    }
                });
                continue;
            }
            ResourceLocation itemResource = ResourceLocation.tryParse((String)itemString);
            if (itemResource == null) continue;
            BuiltInRegistries.ITEM.get(itemResource).ifPresent(itemReference -> itemList.add((Item)itemReference.value()));
        }
        return itemList;
    }

    public static Map<String, List<Item>> getTypeToItemsMap() {
        return TYPE_TO_ITEMS_MAP;
    }
}

