/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnchantHelper {
    @Nullable
    public static Holder<Enchantment> getEnchant(Level level, ResourceKey<Enchantment> enchant) {
        try {
            Registry registryEntryLookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            return registryEntryLookup.getOrThrow(enchant);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    @Nullable
    public static Holder<Enchantment> getEnchant(Level level, String namespace, String path) {
        return level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path)).orElse(null);
    }

    public static boolean hasEnchantment(Level level, ItemStack stack, ResourceKey<Enchantment> enchant) {
        ItemEnchantments itemEnchantmentsComponent = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        Holder<Enchantment> enchantmentHolder = EnchantHelper.getEnchant(level, enchant);
        if (enchantmentHolder == null) {
            return false;
        }
        return itemEnchantmentsComponent.getLevel(enchantmentHolder) > 0;
    }

    public static boolean hasEnchantment(Level level, ItemStack stack, String namespace, String path) {
        ItemEnchantments itemEnchantmentsComponent = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        Holder<Enchantment> enchantmentHolder = EnchantHelper.getEnchant(level, namespace, path);
        if (enchantmentHolder == null) {
            return false;
        }
        return itemEnchantmentsComponent.getLevel(enchantmentHolder) > 0;
    }

    public static int getEnchantLevelFromItem(Level level, ItemStack stack, ResourceKey<Enchantment> enchant) {
        ItemEnchantments itemEnchantmentsComponent = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        Holder<Enchantment> enchantmentHolder = EnchantHelper.getEnchant(level, enchant);
        if (enchantmentHolder == null) {
            return 0;
        }
        return itemEnchantmentsComponent.getLevel(enchantmentHolder);
    }

    public static int getEnchantLevelFromItem(Level level, ItemStack stack, String namespace, String path) {
        ItemEnchantments itemEnchantmentsComponent = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        Holder<Enchantment> enchantmentHolder = EnchantHelper.getEnchant(level, namespace, path);
        if (enchantmentHolder == null) {
            return 0;
        }
        return itemEnchantmentsComponent.getLevel(enchantmentHolder);
    }
}

