/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class OptionButton
extends Button {
    private final ConfigLoaderFromAnnotation.EntryInfo entryInfo;
    private long lastTime;
    private int scrollOffset;
    private boolean reverse = false;
    private int effectCooldown = 0;
    private final String MOD_ID;

    public OptionButton(String MOD_ID, int x, int y, int width, int height, Component message, Component tooltip, Button.OnPress onPress, ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        this.entryInfo = entryInfo;
        if (tooltip != null) {
            this.setTooltip(Tooltip.create((Component)tooltip));
        }
        this.lastTime = System.currentTimeMillis();
        this.scrollOffset = 0;
        this.MOD_ID = MOD_ID;
    }

    public OptionButton(String MOD_ID, int x, int y, int width, int height, Component message, Button.OnPress onPress, ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        this(MOD_ID, x, y, width, height, message, null, onPress, entryInfo);
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.isMouseOver(pMouseX, pMouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.setMessage((Component)Component.literal((String)this.entryInfo.humanizeName).withStyle(ChatFormatting.BOLD));
            MutableComponent info = Component.translatable((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.append((Component)Component.literal((String)"\n\n").append((Component)Component.translatable((String)(this.MOD_ID + ".config.require_restart")).withStyle(ChatFormatting.GOLD)));
            }
            ConfigScreen.infoTab_Info.setMessage((Component)info);
            ConfigScreen.infoTab.arrangeElements();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
    }

    public void renderString(GuiGraphics graphics, @NotNull Font textRenderer, int color) {
        Font font = Minecraft.getInstance().font;
        String leftValue = this.getMessage().getString();
        String rightValue = "";
        try {
            Object object = this.entryInfo.targetField.get(null);
            rightValue = object.toString();
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
        }
        MutableComponent component = Component.literal((String)rightValue);
        if (rightValue.equalsIgnoreCase("true")) {
            component = Component.literal((String)"\u2714").withStyle(ChatFormatting.GREEN);
            rightValue = "\u2714";
        }
        if (rightValue.equalsIgnoreCase("false")) {
            component = Component.literal((String)"\u274c").withStyle(ChatFormatting.RED);
            rightValue = "\u274c";
        }
        int leftTextX = this.getX() + 4;
        int rightTextX = this.getX() + this.width - textRenderer.width(rightValue) - 4;
        float f = this.getY();
        Objects.requireNonNull(textRenderer);
        int textY = (int)(f + (float)(this.height - 9) * 1.1f / 2.0f);
        graphics.drawString(font, (Component)component, rightTextX, textY, 0xFFFFFF);
        String displayedLeftValue = this.trimTextWithEllipsis(leftValue, (int)((double)(this.width - 4) * 0.7), font);
        MutableComponent leftTextComp = Component.literal((String)displayedLeftValue);
        if (this.isChanging()) {
            leftTextComp = Component.literal((String)displayedLeftValue).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
        }
        graphics.drawString(font, (Component)leftTextComp, leftTextX, textY, 0xFFFFFF);
    }

    private boolean isChanging() {
        Object value;
        try {
            value = this.entryInfo.targetField.get(null);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
            return false;
        }
        Object lastValue = ConfigScreen.CONFIG_VALUES.get(this.entryInfo.name);
        return !value.equals(lastValue);
    }

    private String trimTextWithEllipsis(String text, int maxWidth, Font textRenderer) {
        if (textRenderer.width(text) <= maxWidth) {
            return text;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTime > 150L) {
            if (this.effectCooldown > 0) {
                --this.effectCooldown;
                String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
                return textRenderer.plainSubstrByWidth(scrollingText, maxWidth - textRenderer.width("...")) + "...";
            }
            this.scrollOffset = !this.reverse ? (this.scrollOffset + 1) % text.length() : (this.scrollOffset - 1) % text.length();
            String checkText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
            if (textRenderer.width(checkText) + 6 < maxWidth || this.scrollOffset < 1) {
                this.reverse = !this.reverse;
                this.effectCooldown = 90;
            }
            this.lastTime = currentTime;
        }
        String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
        return textRenderer.plainSubstrByWidth(scrollingText, maxWidth - textRenderer.width("...")) + "...";
    }

    private String getScrollingText(String text, int scrollOffset, int maxWidth, Font textRenderer) {
        String visiblePart;
        if (scrollOffset < 0) {
            scrollOffset = 0;
        }
        if (scrollOffset > text.length()) {
            scrollOffset = text.length();
        }
        if (textRenderer.width(visiblePart = text.substring(scrollOffset)) > maxWidth) {
            visiblePart = textRenderer.plainSubstrByWidth(visiblePart, maxWidth);
        }
        return visiblePart;
    }
}

