/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class IntSliderButton
extends AbstractSliderButton {
    String MOD_ID;
    ConfigLoaderFromAnnotation.EntryInfo entryInfo = null;
    ConfigLoaderFromAnnotation.SliderInfo sliderInfo = null;

    public IntSliderButton(String MOD_ID, int width, int height, Component message, ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        super(0, 0, width, height, message, IntSliderButton.normalizeValue(entryInfo));
        this.MOD_ID = MOD_ID;
        this.sliderInfo = entryInfo.slider;
        this.entryInfo = entryInfo;
        this.updateMessage();
    }

    private static double normalizeValue(ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        int value = 0;
        try {
            value = (Integer)entryInfo.targetField.get(null);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Number button...");
            e.printStackTrace();
        }
        return (double)(value - entryInfo.slider.min) / (double)(entryInfo.slider.max - entryInfo.slider.min);
    }

    private int denormalizeValue(double sliderValue) {
        int range = this.sliderInfo.max - this.sliderInfo.min;
        int rawValue = (int)(sliderValue * (double)range) + this.sliderInfo.min;
        int stepped = (rawValue - this.sliderInfo.min) / this.sliderInfo.step * this.sliderInfo.step + this.sliderInfo.min;
        return Math.max(this.sliderInfo.min, Math.min(this.sliderInfo.max, stepped));
    }

    protected void updateMessage() {
        this.setMessage((Component)Component.literal((String)("Value: " + this.denormalizeValue(this.value))));
    }

    protected void applyValue() {
        int currentValue = this.denormalizeValue(this.value);
        Field field = this.entryInfo.targetField;
        try {
            field.set(null, currentValue);
        }
        catch (IllegalAccessException | NumberFormatException e) {
            Constants.LOG.error(" Something went wrong with the config system...");
            e.printStackTrace();
        }
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        double newValue = IntSliderButton.normalizeValue(this.entryInfo);
        if (Math.abs(newValue - this.value) > 1.0E-9) {
            this.value = newValue;
            this.updateMessage();
        }
        if (this.isMouseOver(mouseX, mouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.setMessage((Component)Component.literal((String)this.entryInfo.humanizeName).withStyle(ChatFormatting.BOLD));
            MutableComponent info = Component.translatable((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.append((Component)Component.literal((String)"\n\n").append((Component)Component.translatable((String)(this.MOD_ID + ".config.require_restart")).withStyle(ChatFormatting.GOLD)));
            }
            ConfigScreen.infoTab_Info.setMessage((Component)info);
            ConfigScreen.infoTab.arrangeElements();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
    }
}

