/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.Components.DefaultButton;
import xyz.faewulf.lib.util.config.ConfigScreen.Components.GroupButton;
import xyz.faewulf.lib.util.config.ConfigScreen.Components.NumberButton;

public class ScrollableListWidget
extends ContainerObjectSelectionList<ListEntry> {
    private static final int SCROLLBAR_OFFSET = 7;
    private static String MOD_ID;

    public ScrollableListWidget(String MOD_ID_, Minecraft $$0, int $$1, int $$2, int $$3, int $$4, int $$5) {
        super($$0, $$1, $$2, $$4, $$5);
        MOD_ID = MOD_ID_;
    }

    public void setSize(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void clear() {
        this.clearEntries();
    }

    public void addRow(ConfigLoaderFromAnnotation.EntryInfo entryInfo, AbstractWidget ... widget) {
        ListEntry e = new ListEntry(entryInfo, widget);
        this.addEntry((AbstractSelectionList.Entry)e);
    }

    public int getRowWidth() {
        return (int)Math.max(220.0, (double)this.width * 0.85);
    }

    public static class ListEntry
    extends ContainerObjectSelectionList.Entry<ListEntry> {
        private final int DEFAULT_BUTTON_SIZE = 20;
        private final ArrayList<NarratableEntry> selectables = new ArrayList();
        private final ArrayList<AbstractWidget> elements = new ArrayList();
        private final ConfigLoaderFromAnnotation.EntryInfo entryInfo;
        private final DefaultButton defaultButton;

        public ListEntry(ConfigLoaderFromAnnotation.EntryInfo entryInfo, AbstractWidget ... e) {
            this.entryInfo = entryInfo;
            this.elements.addAll(Arrays.asList(e));
            if (entryInfo.pseudoEntry) {
                this.defaultButton = null;
                return;
            }
            this.defaultButton = new DefaultButton(MOD_ID, 20, 20, 20, 20, (Component)Component.literal((String)"\u21bb"), button -> {
                Object defaultValue = ConfigLoaderFromAnnotation.getDefaultValue(MOD_ID, this.entryInfo.name);
                if (defaultValue != null) {
                    try {
                        this.entryInfo.targetField.set(null, defaultValue);
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.defaultButton.active = false;
            this.elements.add((AbstractWidget)this.defaultButton);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.selectables;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.elements;
        }

        public void renderContent(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Object value;
            AbstractWidget abstractWidget;
            int x = this.getContentX();
            int y = this.getContentY();
            int entryWidth = this.getContentWidth();
            for (int i = 0; i < this.elements.size() - 1; ++i) {
                abstractWidget = this.elements.get(i);
                int width = (entryWidth - 2 - 20) / (this.elements.size() - 1);
                if (abstractWidget instanceof NumberButton) {
                    abstractWidget.setWidth(width - 6);
                    abstractWidget.setX(x + i * width + 2 - 3 + 2);
                    abstractWidget.setY(y + 2);
                } else {
                    abstractWidget.setWidth(width - 2);
                    abstractWidget.setX(x + i * width + 2 - 3);
                    abstractWidget.setY(y);
                }
                abstractWidget.render(context, mouseX, mouseY, tickDelta);
            }
            if (this.entryInfo.pseudoEntry) {
                abstractWidget = this.elements.getFirst();
                if (abstractWidget instanceof GroupButton) {
                    GroupButton groupButton = (GroupButton)abstractWidget;
                    groupButton.setWidth(entryWidth);
                    groupButton.setHeight(20);
                    groupButton.setX(x);
                    groupButton.setY(y);
                    groupButton.render(context, mouseX, mouseY, tickDelta);
                }
                return;
            }
            this.defaultButton.setWidth(20);
            this.defaultButton.setX(x + entryWidth - 20 - 2 - 3);
            this.defaultButton.setY(y);
            this.defaultButton.render(context, mouseX, mouseY, tickDelta);
            try {
                value = this.entryInfo.targetField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            Object defaultValue = ConfigLoaderFromAnnotation.getDefaultValue(MOD_ID, this.entryInfo.name);
            this.defaultButton.active = !value.equals(defaultValue);
        }
    }
}

