/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import xyz.faewulf.lib.util.config.Config;
import xyz.faewulf.lib.util.config.ConfigRecord;
import xyz.faewulf.lib.util.config.Entry;
import xyz.faewulf.lib.util.config.SliderEntry;

public class ConfigLoaderFromAnnotation {
    public static Map<String, Map<String, EntryInfo>> loadConfig(String MOD_ID) {
        ConfigRecord configRecord = Config.LIST_OF_CONFIG.get(MOD_ID);
        if (configRecord == null) {
            return new HashMap<String, Map<String, EntryInfo>>();
        }
        LinkedHashMap<String, Map<String, EntryInfo>> configMap = new LinkedHashMap<String, Map<String, EntryInfo>>();
        Field[] fields = configRecord.getConfigClass().getDeclaredFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Entry.class)) continue;
            Entry entry = field.getAnnotation(Entry.class);
            String category = entry.category();
            String name = entry.name();
            String info = entry.info();
            boolean hidden = entry.hidden();
            boolean require_restart = entry.require_restart();
            String group = entry.group();
            try {
                Object value = field.get(null);
                EntryInfo entryInfo = new EntryInfo(field, field.getName(), name, info, value, require_restart, hidden, group);
                SliderEntry sliderAnno = field.getAnnotation(SliderEntry.class);
                if (sliderAnno != null) {
                    if (field.getType() != Integer.TYPE) {
                        throw new IllegalArgumentException("@SliderEntry can only be applied to int fields: " + field.getName());
                    }
                    int min = sliderAnno.min();
                    int max = sliderAnno.max();
                    int step = sliderAnno.step();
                    entryInfo.setSlider(new SliderInfo(min, max, step));
                }
                configMap.computeIfAbsent(category, k -> new LinkedHashMap());
                ((Map)configMap.get(category)).put(name, entryInfo);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return configMap;
    }

    public static Map<String, EntryInfo> loadConfig_EntryOnly(String MOD_ID) {
        ConfigRecord configRecord = Config.LIST_OF_CONFIG.get(MOD_ID);
        if (configRecord == null) {
            return new HashMap<String, EntryInfo>();
        }
        LinkedHashMap<String, EntryInfo> configMap = new LinkedHashMap<String, EntryInfo>();
        Field[] fields = configRecord.getConfigClass().getDeclaredFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Entry.class)) continue;
            Entry entry = field.getAnnotation(Entry.class);
            String name = entry.name();
            String info = entry.info();
            boolean hidden = entry.hidden();
            boolean require_restart = entry.require_restart();
            String group = entry.group();
            try {
                Object value = field.get(null);
                EntryInfo entryInfo = new EntryInfo(field, field.getName(), name, info, value, require_restart, hidden, group);
                SliderEntry sliderAnno = field.getAnnotation(SliderEntry.class);
                if (sliderAnno != null) {
                    if (field.getType() != Integer.TYPE) {
                        throw new IllegalArgumentException("@SliderEntry can only be applied to int fields: " + field.getName());
                    }
                    int min = sliderAnno.min();
                    int max = sliderAnno.max();
                    int step = sliderAnno.step();
                    entryInfo.setSlider(new SliderInfo(min, max, step));
                }
                configMap.put(name, entryInfo);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return configMap;
    }

    public static Object getDefaultValue(String MOD_ID, String configName) {
        ConfigRecord configRecord = Config.LIST_OF_CONFIG.get(MOD_ID);
        if (configRecord == null) {
            return null;
        }
        return configRecord.getDEFAULT_VALUES().get(configName);
    }

    public static Map<String, Object> getAllDefaultValues(String MOD_ID) {
        ConfigRecord configRecord = Config.LIST_OF_CONFIG.get(MOD_ID);
        if (configRecord == null) {
            return new HashMap<String, Object>();
        }
        return configRecord.getDEFAULT_VALUES();
    }

    public static List<String> getGroups(String MOD_ID, String category) {
        ConfigRecord configRecord = Config.LIST_OF_CONFIG.get(MOD_ID);
        if (configRecord == null) {
            return new ArrayList<String>();
        }
        if (!configRecord.getGROUP_OF_CATEGORY().containsKey(category)) {
            return new ArrayList<String>();
        }
        return configRecord.getGROUP_OF_CATEGORY().get(category);
    }

    public static void initializeDefaults(ConfigRecord configRecord) {
        try {
            for (Field field : configRecord.getConfigClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Entry.class)) continue;
                Object defaultValue = field.get(null);
                configRecord.getDEFAULT_VALUES().put(field.getName(), defaultValue);
                Entry entry = field.getAnnotation(Entry.class);
                String group = entry.group();
                String category = entry.category();
                configRecord.getGROUP_OF_CATEGORY().computeIfAbsent(category, k -> new ArrayList());
                if (configRecord.getGROUP_OF_CATEGORY().get(category).contains(group)) continue;
                configRecord.getGROUP_OF_CATEGORY().get(category).add(group);
            }
            configRecord.getGROUP_OF_CATEGORY().forEach((s, strings) -> Collections.sort(strings));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static class EntryInfo {
        public String info;
        public boolean require_restart;
        public String name;
        public Field targetField;
        public String humanizeName;
        public Object value;
        public String group;
        public boolean hidden;
        public SliderInfo slider = null;
        public boolean pseudoEntry = true;
        public boolean visibleInConfig = true;

        public EntryInfo(Field field, String name, String humanizeName, String info, Object value, boolean require_restart, boolean hidden, String group) {
            this.name = name;
            this.info = info;
            this.require_restart = require_restart;
            this.targetField = field;
            this.humanizeName = humanizeName;
            this.value = value;
            this.group = group;
            this.pseudoEntry = false;
            this.hidden = hidden;
        }

        public void setSlider(SliderInfo slider) {
            this.slider = slider;
        }

        public EntryInfo(String name) {
            this.name = name;
        }
    }

    public static class SliderInfo {
        public int min;
        public int max;
        public int step;

        public SliderInfo(int min, int max, int step) {
            this.max = max;
            this.min = min;
            this.step = Math.max(step, 1);
        }
    }
}

