/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class NumberButtonInfo
extends StringWidget {
    private final ConfigLoaderFromAnnotation.EntryInfo entryInfo;
    private final Component initMessage;
    private final String MOD_ID;

    public NumberButtonInfo(String MOD_ID, int width, int height, Component message, Font font, ConfigLoaderFromAnnotation.EntryInfo info) {
        super(width, height, message, font);
        this.entryInfo = info;
        this.initMessage = message;
        this.MOD_ID = MOD_ID;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Component valueStatusIndicator = this.initMessage;
        if (this.isChanging()) {
            valueStatusIndicator = Component.literal((String)this.initMessage.getString()).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
        }
        this.setMessage(valueStatusIndicator);
        if (this.isMouseOver(mouseX, mouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.setMessage((Component)Component.literal((String)this.entryInfo.humanizeName).withStyle(ChatFormatting.BOLD));
            MutableComponent info = Component.translatable((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.append((Component)Component.literal((String)"\n\n").append((Component)Component.translatable((String)(this.MOD_ID + ".config.require_restart")).withStyle(ChatFormatting.GOLD)));
            }
            ConfigScreen.infoTab_Info.setMessage((Component)info);
            ConfigScreen.infoTab.arrangeElements();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
    }

    private boolean isChanging() {
        Object value;
        try {
            value = this.entryInfo.targetField.get(null);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
            return false;
        }
        Object lastValue = ConfigScreen.CONFIG_VALUES.get(this.entryInfo.name);
        return !value.equals(lastValue);
    }
}

