/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.faewulf.lib.util.config.Config;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigTab;
import xyz.faewulf.lib.util.config.ConfigScreen.ScrollableListWidget;

public class ConfigScreen
extends Screen {
    private final String MOD_ID;
    private final ResourceLocation ATLAS_TEXTURE;
    private final int ATLAS_SIZE = 96;
    private final int TILE_SIZE = 32;
    private int[][] tileMap;
    private int tilesX;
    private int tilesY;
    private final Screen parent;
    private final Minecraft client;
    private static final int RIGHT_TAB_PADDING = 2;
    private Boolean isChanged = false;
    public static Map<String, Object> CONFIG_VALUES = new LinkedHashMap<String, Object>();
    public static List<ConfigLoaderFromAnnotation.EntryInfo> CONFIG_ENTRIES = new ArrayList<ConfigLoaderFromAnnotation.EntryInfo>();
    private final TabManager tabManager = new TabManager(x$0 -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
    }, x$0 -> this.removeWidget((GuiEventListener)x$0));
    @Nullable
    private TabNavigationBar tabNavigationBar;
    @Nullable
    private ScrollableListWidget slw;
    @Nullable
    private Tab selectedTab;
    @Nullable
    private GridLayout rightTab;
    public static GridLayout infoTab;
    public static String currentInfo;
    public static boolean updateCall;
    @Nullable
    private EditBox searchBar;
    @Nullable
    private Button ButtonReset_Cancel;
    @Nullable
    private Button ButtonUndo;
    @Nullable
    private Button ButtonDone_Save;
    public static MultiLineTextWidget infoTab_Title;
    public static MultiLineTextWidget infoTab_Info;

    protected ConfigScreen(Screen parent, String MOD_ID) {
        super((Component)Component.translatable((String)(MOD_ID + ".config.title")));
        this.parent = parent;
        this.client = Minecraft.getInstance();
        this.tilesX = (int)Math.ceil((float)this.width * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.height * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.MOD_ID = MOD_ID;
        this.ATLAS_TEXTURE = ResourceLocation.tryBuild((String)MOD_ID, (String)"textures/gui/atlas_background.png");
    }

    public static Screen getScreen(Screen parent, String MOD_ID) {
        return new ConfigScreen(parent, MOD_ID);
    }

    protected void init() {
        CONFIG_ENTRIES.clear();
        CONFIG_VALUES.clear();
        this.generateRandomTileMap();
        Map<String, Map<String, ConfigLoaderFromAnnotation.EntryInfo>> configMap = ConfigLoaderFromAnnotation.loadConfig(this.MOD_ID);
        TabNavigationBar.Builder tabBuilder = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width);
        configMap.forEach((s, stringEntryTypeMap) -> {
            ConfigTab configTab = new ConfigTab(this.MOD_ID, (String)s, (Map<String, ConfigLoaderFromAnnotation.EntryInfo>)stringEntryTypeMap);
            if (!configTab.isShouldHideFromConfigScreen()) {
                tabBuilder.addTabs(new Tab[]{configTab});
            }
        });
        this.tabNavigationBar = tabBuilder.build();
        this.rightTab = new GridLayout();
        GridLayout.RowHelper rightTabRowHelper = this.rightTab.createRowHelper(2);
        rightTabRowHelper.defaultCellSetting().alignHorizontallyCenter().alignVerticallyBottom().padding(1);
        this.searchBar = (EditBox)rightTabRowHelper.addChild((LayoutElement)new EditBox(this.font, 0, 0, 150, 20, (Component)Component.translatable((String)(this.MOD_ID + ".config.searchbar.hint"))), 2);
        this.searchBar.setHint((Component)Component.translatable((String)(this.MOD_ID + ".config.searchbar.hint")));
        this.searchBar.setResponder(this::pushList);
        this.ButtonReset_Cancel = (Button)rightTabRowHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)(this.MOD_ID + ".config.reset")), button -> {
            if (this.isChanged.booleanValue()) {
                this.undoConfig();
                this.onClose();
                return;
            }
            Map<String, Object> defaultValue = ConfigLoaderFromAnnotation.getAllDefaultValues(this.MOD_ID);
            CONFIG_ENTRIES.forEach(entryInfo -> {
                try {
                    entryInfo.targetField.set(null, defaultValue.get(entryInfo.name));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }).width(75).tooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".config.reset.tooltip")))).build());
        this.ButtonUndo = (Button)rightTabRowHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)(this.MOD_ID + ".config.undo")), button -> this.undoConfig()).width(75).tooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".config.undo.tooltip")))).build());
        this.ButtonUndo.active = false;
        this.ButtonDone_Save = (Button)rightTabRowHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)(this.MOD_ID + ".config.exit")), button -> {
            if (this.isChanged.booleanValue()) {
                Config.save(this.MOD_ID);
                this.updateConfig();
            } else {
                this.undoConfig();
                this.onClose();
            }
        }).width(154).tooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".config.exit.tooltip")))).build(), 2);
        infoTab = new GridLayout();
        GridLayout.RowHelper infoTabRowHelper = infoTab.createRowHelper(1);
        infoTabRowHelper.defaultCellSetting().padding(4);
        infoTab_Title = (MultiLineTextWidget)infoTabRowHelper.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.literal((String)""), this.font));
        infoTab_Info = (MultiLineTextWidget)infoTabRowHelper.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.literal((String)""), this.font));
        infoTab_Title.setMaxWidth(154);
        infoTab_Info.setMaxWidth(154);
        ScreenRectangle screenRectangle = new ScreenRectangle(0, this.tabNavigationBar.getRectangle().bottom(), this.width - this.rightTab.getWidth(), this.height - this.tabNavigationBar.getRectangle().bottom());
        this.slw = new ScrollableListWidget(this.MOD_ID, this.client, screenRectangle.width(), screenRectangle.height(), 24, screenRectangle.height(), 20);
        this.tabNavigationBar.selectTab(0, false);
        this.selectedTab = null;
        this.addRenderableWidget((GuiEventListener)this.slw);
        infoTab.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.rightTab.visitWidgets(abstractWidget -> {
            abstractWidget.setTabOrderGroup(1);
            this.addRenderableWidget((GuiEventListener)abstractWidget);
        });
        this.addRenderableWidget((GuiEventListener)this.tabNavigationBar);
        this.repositionElements();
    }

    protected void repositionElements() {
        this.tilesX = (int)Math.ceil((float)this.width * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.height * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.generateRandomTileMap();
        if (this.tabNavigationBar != null && this.rightTab != null && this.slw != null) {
            this.tabNavigationBar.setWidth(this.width);
            this.tabNavigationBar.arrangeElements();
            this.rightTab.arrangeElements();
            infoTab.arrangeElements();
            int i = this.tabNavigationBar.getRectangle().bottom();
            FrameLayout.centerInRectangle((LayoutElement)this.rightTab, (int)(this.width - this.rightTab.getWidth() - 2), (int)(this.height - this.rightTab.getHeight() - 2), (int)(this.rightTab.getWidth() + 2), (int)(this.rightTab.getHeight() + 2));
            FrameLayout.alignInRectangle((LayoutElement)infoTab, (int)(this.width - this.rightTab.getWidth() - 2), (int)i, (int)(this.rightTab.getWidth() + 2), (int)(this.height - i - this.rightTab.getHeight()), (float)0.0f, (float)0.0f);
            ScreenRectangle screenRectangle = new ScreenRectangle(0, i, this.width - this.rightTab.getWidth() - 2, this.height);
            HeaderAndFooterLayout headerAndFooterLayout = new HeaderAndFooterLayout((Screen)this, i, 0);
            this.slw.updateSize(screenRectangle.width(), headerAndFooterLayout);
            this.tabManager.setTabArea(screenRectangle);
        }
    }

    public void tick() {
        super.tick();
        if (this.slw != null && this.searchBar != null && this.selectedTab != this.tabManager.getCurrentTab()) {
            this.pushList(this.searchBar.getValue());
        }
        if (updateCall) {
            updateCall = false;
            this.pushListWithoutSetScroll(this.searchBar == null ? null : this.searchBar.getValue());
        }
        Map<String, ConfigLoaderFromAnnotation.EntryInfo> current_config_data = ConfigLoaderFromAnnotation.loadConfig_EntryOnly(this.MOD_ID);
        this.isChanged = false;
        current_config_data.forEach((s, entryInfo) -> {
            try {
                Object pastValue = CONFIG_VALUES.get(entryInfo.name);
                Object currentValue = entryInfo.targetField.get(null);
                if (pastValue != null && !pastValue.equals(currentValue)) {
                    this.isChanged = true;
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        if (this.ButtonUndo != null && this.ButtonDone_Save != null && this.ButtonReset_Cancel != null && this.isChanged.booleanValue()) {
            this.ButtonDone_Save.setMessage((Component)Component.translatable((String)(this.MOD_ID + ".config.save")).withStyle(ChatFormatting.GREEN));
            this.ButtonDone_Save.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".config.save.tooltip"))));
            this.ButtonReset_Cancel.setMessage((Component)Component.translatable((String)(this.MOD_ID + ".config.cancel")).withStyle(ChatFormatting.RED));
            this.ButtonReset_Cancel.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".config.cancel.tooltip"))));
            this.ButtonUndo.active = true;
        } else {
            this.ButtonReset_Cancel.setMessage((Component)Component.translatable((String)(this.MOD_ID + ".config.reset")));
            this.ButtonReset_Cancel.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".config.reset.tooltip"))));
            this.ButtonDone_Save.setMessage((Component)Component.translatable((String)(this.MOD_ID + ".config.exit")));
            this.ButtonDone_Save.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".config.exit.tooltip"))));
            this.ButtonUndo.active = false;
        }
    }

    private void updateConfig() {
        for (ConfigLoaderFromAnnotation.EntryInfo configEntry : CONFIG_ENTRIES) {
            try {
                CONFIG_VALUES.put(configEntry.name, configEntry.targetField.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void undoConfig() {
        for (ConfigLoaderFromAnnotation.EntryInfo configEntry : CONFIG_ENTRIES) {
            try {
                Object value = CONFIG_VALUES.get(configEntry.name);
                configEntry.targetField.set(null, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void pushList(String filter) {
        if (this.slw == null) {
            return;
        }
        this.pushListWithoutSetScroll(filter);
        this.slw.setScrollAmount(0.0);
    }

    private void pushListWithoutSetScroll(@Nullable String filter) {
        if (this.slw == null || this.searchBar == null) {
            return;
        }
        this.selectedTab = this.tabManager.getCurrentTab();
        this.slw.clear();
        Tab tab = this.selectedTab;
        if (tab instanceof ConfigTab) {
            ConfigTab configTab = (ConfigTab)tab;
            configTab.tabEntries.forEach((entryType, buttons) -> {
                if (!entryType.visibleInConfig) {
                    return;
                }
                if (entryType.pseudoEntry) {
                    this.slw.addRow((ConfigLoaderFromAnnotation.EntryInfo)entryType, buttons.toArray(new AbstractWidget[0]));
                } else if (filter == null || filter.isEmpty()) {
                    this.slw.addRow((ConfigLoaderFromAnnotation.EntryInfo)entryType, buttons.toArray(new AbstractWidget[0]));
                } else if (entryType.name.contains(filter.toLowerCase())) {
                    this.slw.addRow((ConfigLoaderFromAnnotation.EntryInfo)entryType, buttons.toArray(new AbstractWidget[0]));
                }
            });
        }
    }

    public void onClose() {
        if (this.client != null) {
            this.client.setScreen(this.parent);
        } else {
            super.onClose();
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int $$1, int $$2, float $$3) {
        this.renderBackground(guiGraphics, $$1, $$2, $$3);
        this.drawRandomTiledBackground(guiGraphics);
        guiGraphics.fillGradient(this.rightTab.getX() - 2, this.tabNavigationBar.getRectangle().bottom(), this.width, this.height, -1157627904, -1157627904);
        super.render(guiGraphics, $$1, $$2, $$3);
    }

    private void drawRandomTiledBackground(GuiGraphics guiGraphics) {
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileIndex = this.tileMap[x][y];
                int tileX = tileIndex % tilesPerRow * 32;
                int tileY = tileIndex / tilesPerRow * 32;
                guiGraphics.blit(RenderType::guiOpaqueTexturedBackground, this.ATLAS_TEXTURE, x * 32, y * 32, (float)tileX, (float)tileY, 32, 32, 96, 96);
            }
        }
    }

    private void generateRandomTileMap() {
        Random random = new Random();
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileX = random.nextInt(tilesPerRow);
                int tileY = random.nextInt(tilesPerRow);
                this.tileMap[x][y] = tileY * tilesPerRow + tileX;
            }
        }
    }

    static {
        updateCall = false;
    }
}

