/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.infoScreen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.faewulf.lib.util.config.Config;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;
import xyz.faewulf.lib.util.config.infoScreen.rainITem;

public class ModInfoScreen
extends Screen {
    private final String MOD_ID;
    private final ResourceLocation MAIN_IMAGE;
    private final ResourceLocation LIGHT_RAYS;
    private final Screen parent;
    private final Minecraft client;
    private final List<rainITem> fallingEntities = new ArrayList<rainITem>();
    public final ResourceLocation ATLAS_TEXTURE;
    private final int ATLAS_SIZE = 96;
    private final int TILE_SIZE = 32;
    private int[][] tileMap;
    private int tilesX;
    private int tilesY;
    private final float logo_offset_Y = 20.0f;
    private final ResourceLocation ICON_DISCORD;
    private final ResourceLocation ICON_KOFI;
    private final ResourceLocation ICON_GITHUB;
    private String URL_GITHUB = "https://github.com/FaeWulf";
    private String URL_WEBSITE = "https://faewulf.xyz/";
    private String URL_DONATE = "https://ko-fi.com/faewulf";
    private String URL_DISCORD = "https://faewulf.xyz/discord";
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 100, 60);
    private GridLayout contentLayout;
    private GridLayout footerLayout;
    private Button settingButton;
    private float time = 0.0f;

    protected ModInfoScreen(Screen parent, String MOD_ID) {
        super((Component)Component.literal((String)"Info"));
        this.parent = parent;
        this.client = Minecraft.getInstance();
        this.tilesX = (int)Math.ceil((float)this.width * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.height * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.MOD_ID = MOD_ID;
        this.MAIN_IMAGE = ResourceLocation.tryBuild((String)MOD_ID, (String)"textures/gui/d.png");
        this.LIGHT_RAYS = ResourceLocation.tryBuild((String)MOD_ID, (String)"textures/gui/light_rays.png");
        this.ATLAS_TEXTURE = ResourceLocation.tryBuild((String)MOD_ID, (String)"textures/gui/atlas_background.png");
        this.ICON_DISCORD = ResourceLocation.tryBuild((String)MOD_ID, (String)"icon/discord");
        this.ICON_KOFI = ResourceLocation.tryBuild((String)MOD_ID, (String)"icon/kofi");
        this.ICON_GITHUB = ResourceLocation.tryBuild((String)MOD_ID, (String)"icon/github");
    }

    public static ModInfoScreen getScreen(Screen parent, String MOD_ID) {
        return new ModInfoScreen(parent, MOD_ID);
    }

    public void setUrls(@Nullable String discord, @Nullable String website, @Nullable String donate, @Nullable String sourcecode) {
        if (discord != null) {
            this.URL_DISCORD = discord;
        }
        if (sourcecode != null) {
            this.URL_GITHUB = sourcecode;
        }
        if (website != null) {
            this.URL_WEBSITE = website;
        }
        if (donate != null) {
            this.URL_DONATE = donate;
        }
    }

    protected void init() {
        this.generateRandomTileMap();
        Config.reloadConfig(this.MOD_ID);
        for (int i = 0; i < 25; ++i) {
            int texture = i % 9;
            float x = (float)(Math.random() * (double)this.width);
            float y = (float)(Math.random() * (double)this.height);
            float velocityX = (float)(Math.random() * 1.0) - 0.5f;
            float velocityY = 1.0f + (float)(Math.random() * 1.0);
            float rotationSpeed = (float)(Math.random() * 14.0 - 7.0);
            this.fallingEntities.add(new rainITem(texture, x, y, velocityX, velocityY, rotationSpeed, this.width, this.height));
        }
        this.contentLayout = new GridLayout();
        this.footerLayout = new GridLayout();
        GridLayout.RowHelper rowHelper = this.contentLayout.createRowHelper(1);
        rowHelper.defaultCellSetting().padding(4).alignHorizontallyCenter();
        this.settingButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)(this.MOD_ID + ".info.configurations")), button -> this.client.setScreen(ConfigScreen.getScreen(this, this.MOD_ID))).build());
        if (ConfigLoaderFromAnnotation.loadConfig(this.MOD_ID).isEmpty()) {
            this.settingButton.active = false;
        }
        GridLayout.RowHelper rowHelperFooterLayout = this.footerLayout.createRowHelper(5);
        rowHelperFooterLayout.defaultCellSetting().alignHorizontallyCenter().padding(2);
        rowHelperFooterLayout.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"\ud83c\udf10"), button -> this.openWebLink(this.URL_WEBSITE)).width(20).tooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".info.website.tooltip")))).build());
        SpriteIconButton iconButton = SpriteIconButton.builder((Component)Component.literal((String)"Kofi").withStyle(ChatFormatting.RED), button -> this.openWebLink(this.URL_DONATE), (boolean)true).size(20, 20).sprite(this.ICON_KOFI, 20, 20).build();
        iconButton.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".info.kofi.tooltip"))));
        rowHelperFooterLayout.addChild((LayoutElement)iconButton, 1);
        rowHelperFooterLayout.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"Close"), button -> this.onClose()).width(100).build(), 1);
        iconButton = SpriteIconButton.builder((Component)Component.literal((String)"Discord").withStyle(ChatFormatting.BLUE), button -> this.openWebLink(this.URL_DISCORD), (boolean)true).size(20, 20).sprite(this.ICON_DISCORD, 16, 16).build();
        iconButton.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".info.discord.tooltip"))));
        rowHelperFooterLayout.addChild((LayoutElement)iconButton, 1);
        iconButton = SpriteIconButton.builder((Component)Component.literal((String)"Github"), button -> this.openWebLink(this.URL_GITHUB), (boolean)true).size(20, 20).sprite(this.ICON_GITHUB, 16, 16).build();
        iconButton.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.MOD_ID + ".info.github.tooltip"))));
        rowHelperFooterLayout.addChild((LayoutElement)iconButton, 1);
        this.layout.addToContents((LayoutElement)this.contentLayout);
        this.layout.addToFooter((LayoutElement)this.footerLayout);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    public void tick() {
        super.tick();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.drawRandomTiledBackground(guiGraphics);
        this.randomShtShowering(guiGraphics, pPartialTick);
        guiGraphics.fillGradient(0, 0, this.width, this.height, -1442840576, Integer.MIN_VALUE);
        this.time += pPartialTick * 0.05f;
        this.drawLightRays(guiGraphics);
        this.drawWobblingImage(guiGraphics);
    }

    private void drawLightRays(GuiGraphics guiGraphics) {
        int centerX = this.width / 2;
        int centerY = (int)(((float)this.layout.getHeaderHeight() + 20.0f) / 2.0f);
        int size = 128;
        float rotationAngle = this.time * 20.0f;
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        float wobbleOffsetY = (float)Math.sin(this.time) * 5.0f;
        matrixStack.translate((float)centerX, (float)centerY + wobbleOffsetY, 0.0f);
        matrixStack.mulPose(Axis.ZP.rotationDegrees(rotationAngle));
        guiGraphics.pose().translate((float)(-size) / 2.0f, (float)(-size) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(RenderType::guiTextured, this.LIGHT_RAYS, 0, 0, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.disableBlend();
        matrixStack.popPose();
    }

    private void drawWobblingImage(GuiGraphics guiGraphics) {
        int imageSize = 64;
        int centerX = this.width / 2;
        int centerY = (int)(((float)this.layout.getHeaderHeight() + 20.0f) / 2.0f);
        float wobbleOffsetY = (float)Math.sin(this.time) * 5.0f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)centerX, (float)centerY + wobbleOffsetY, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(RenderType::guiTextured, this.MAIN_IMAGE, -imageSize / 2, -imageSize / 2, 0.0f, 0.0f, imageSize, imageSize, imageSize, imageSize);
        RenderSystem.disableBlend();
        guiGraphics.pose().popPose();
    }

    protected void repositionElements() {
        this.tilesX = (int)Math.ceil((float)this.width * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.height * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.generateRandomTileMap();
        this.layout.arrangeElements();
        this.fallingEntities.forEach(rainITem2 -> rainITem2.updateScreenSize(this.width, this.height));
    }

    public void onClose() {
        if (this.client != null) {
            this.client.setScreen(this.parent);
        } else {
            super.onClose();
        }
    }

    private void randomShtShowering(GuiGraphics guiGraphics, float delta) {
        for (rainITem entity : this.fallingEntities) {
            entity.update(delta);
            entity.render(guiGraphics, delta);
        }
    }

    private void drawRandomTiledBackground(GuiGraphics guiGraphics) {
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileIndex = this.tileMap[x][y];
                int tileX = tileIndex % tilesPerRow * 32;
                int tileY = tileIndex / tilesPerRow * 32;
                guiGraphics.blit(RenderType::guiTextured, this.ATLAS_TEXTURE, x * 32, y * 32, (float)tileX, (float)tileY, 32, 32, 96, 96);
            }
        }
    }

    private void generateRandomTileMap() {
        Random random = new Random();
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileX = random.nextInt(tilesPerRow);
                int tileY = random.nextInt(tilesPerRow);
                this.tileMap[x][y] = tileY * tilesPerRow + tileX;
            }
        }
    }

    private void openWebLink(String url) {
        this.client.setScreen((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                Util.getPlatform().openUri(url);
            }
            this.client.setScreen((Screen)this);
        }, url, true));
    }
}

