/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class NumberButtonInfo
extends class_7842 {
    private final ConfigLoaderFromAnnotation.EntryInfo entryInfo;
    private final class_2561 initMessage;
    private final String MOD_ID;
    private long lastTime;
    private int scrollOffset;
    private boolean reverse = false;
    private int effectCooldown = 0;

    public NumberButtonInfo(String MOD_ID, int width, int height, class_2561 message, class_327 font, ConfigLoaderFromAnnotation.EntryInfo info) {
        super(width, height, message, font);
        this.entryInfo = info;
        this.initMessage = message;
        this.MOD_ID = MOD_ID;
        this.lastTime = System.currentTimeMillis();
        this.scrollOffset = 0;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_327 font = class_310.method_1551().field_1772;
        String scrollingText = this.trimTextWithEllipsis(this.initMessage.getString(), this.field_22758, font);
        class_5250 valueStatusIndicator = class_2561.method_43470((String)scrollingText);
        if (this.isChanging()) {
            valueStatusIndicator = class_2561.method_43470((String)scrollingText).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
        }
        this.method_25355((class_2561)valueStatusIndicator);
        if (this.method_25405(mouseX, mouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.method_25355((class_2561)class_2561.method_43470((String)this.entryInfo.humanizeName).method_27692(class_124.field_1067));
            class_5250 info = class_2561.method_43471((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.method_10852((class_2561)class_2561.method_43470((String)"\n\n").method_10852((class_2561)class_2561.method_43471((String)(this.MOD_ID + ".config.require_restart")).method_27692(class_124.field_1065)));
            }
            ConfigScreen.infoTab_Info.method_25355((class_2561)info);
            ConfigScreen.infoTab.method_48222();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    private boolean isChanging() {
        Object value;
        try {
            value = this.entryInfo.targetField.get(null);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
            return false;
        }
        Object lastValue = ConfigScreen.CONFIG_VALUES.get(this.entryInfo.name);
        return !value.equals(lastValue);
    }

    private String trimTextWithEllipsis(String text, int maxWidth, class_327 textRenderer) {
        if (textRenderer.method_1727(text) <= maxWidth) {
            return text;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTime > 150L) {
            if (this.effectCooldown > 0) {
                --this.effectCooldown;
                String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
                return textRenderer.method_27523(scrollingText, maxWidth - textRenderer.method_1727("...")) + "...";
            }
            this.scrollOffset = !this.reverse ? (this.scrollOffset + 1) % text.length() : (this.scrollOffset - 1) % text.length();
            String checkText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
            if (textRenderer.method_1727(checkText) + 6 < maxWidth || this.scrollOffset < 1) {
                this.reverse = !this.reverse;
                this.effectCooldown = 90;
            }
            this.lastTime = currentTime;
        }
        String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
        return textRenderer.method_27523(scrollingText, maxWidth - textRenderer.method_1727("...")) + "...";
    }

    private String getScrollingText(String text, int scrollOffset, int maxWidth, class_327 textRenderer) {
        String visiblePart;
        if (scrollOffset < 0) {
            scrollOffset = 0;
        }
        if (scrollOffset > text.length()) {
            scrollOffset = text.length();
        }
        if (textRenderer.method_1727(visiblePart = text.substring(scrollOffset)) > maxWidth) {
            visiblePart = textRenderer.method_27523(visiblePart, maxWidth);
        }
        return visiblePart;
    }
}

