/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class OptionButton
extends class_4185 {
    private final ConfigLoaderFromAnnotation.EntryInfo entryInfo;
    private long lastTime;
    private int scrollOffset;
    private boolean reverse = false;
    private int effectCooldown = 0;
    private final String MOD_ID;

    public OptionButton(String MOD_ID, int x, int y, int width, int height, class_2561 message, class_2561 tooltip, class_4185.class_4241 onPress, ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        super(x, y, width, height, message, onPress, field_40754);
        this.entryInfo = entryInfo;
        if (tooltip != null) {
            this.method_47400(class_7919.method_47407((class_2561)tooltip));
        }
        this.lastTime = System.currentTimeMillis();
        this.scrollOffset = 0;
        this.MOD_ID = MOD_ID;
    }

    public OptionButton(String MOD_ID, int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress, ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        this(MOD_ID, x, y, width, height, message, null, onPress, entryInfo);
    }

    protected void method_48579(@NotNull class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_48579(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.method_25405(pMouseX, pMouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.method_25355((class_2561)class_2561.method_43470((String)this.entryInfo.humanizeName).method_27692(class_124.field_1067));
            class_5250 info = class_2561.method_43471((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.method_10852((class_2561)class_2561.method_43470((String)"\n\n").method_10852((class_2561)class_2561.method_43471((String)(this.MOD_ID + ".config.require_restart")).method_27692(class_124.field_1065)));
            }
            ConfigScreen.infoTab_Info.method_25355((class_2561)info);
            ConfigScreen.infoTab.method_48222();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
    }

    public void method_48589(@NotNull class_332 graphics, @NotNull class_327 textRenderer, int color) {
        class_327 font = class_310.method_1551().field_1772;
        String leftValue = this.method_25369().getString();
        String rightValue = "";
        try {
            Object object = this.entryInfo.targetField.get(null);
            rightValue = object.toString();
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
        }
        class_5250 component = class_2561.method_43470((String)rightValue);
        if (rightValue.equalsIgnoreCase("true")) {
            component = class_2561.method_43470((String)"\u2714").method_27692(class_124.field_1060);
            rightValue = "\u2714";
        }
        if (rightValue.equalsIgnoreCase("false")) {
            component = class_2561.method_43470((String)"\u274c").method_27692(class_124.field_1061);
            rightValue = "\u274c";
        }
        int leftTextX = this.method_46426() + 4;
        int rightTextX = this.method_46426() + this.field_22758 - textRenderer.method_1727(rightValue) - 4;
        float f = this.method_46427();
        Objects.requireNonNull(textRenderer);
        int textY = (int)(f + (float)(this.field_22759 - 9) * 1.1f / 2.0f);
        graphics.method_27535(font, (class_2561)component, rightTextX, textY, class_9848.method_61317((float)this.field_22765));
        String displayedLeftValue = this.trimTextWithEllipsis(leftValue, (int)((double)(this.field_22758 - 4) * 0.7), font);
        class_5250 leftTextComp = class_2561.method_43470((String)displayedLeftValue);
        if (this.isChanging()) {
            leftTextComp = class_2561.method_43470((String)displayedLeftValue).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
        }
        graphics.method_27535(font, (class_2561)leftTextComp, leftTextX, textY, class_9848.method_61317((float)this.field_22765));
    }

    private boolean isChanging() {
        Object value;
        try {
            value = this.entryInfo.targetField.get(null);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
            return false;
        }
        Object lastValue = ConfigScreen.CONFIG_VALUES.get(this.entryInfo.name);
        return !value.equals(lastValue);
    }

    private String trimTextWithEllipsis(String text, int maxWidth, class_327 textRenderer) {
        if (textRenderer.method_1727(text) <= maxWidth) {
            return text;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTime > 150L) {
            if (this.effectCooldown > 0) {
                --this.effectCooldown;
                String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
                return textRenderer.method_27523(scrollingText, maxWidth - textRenderer.method_1727("...")) + "...";
            }
            this.scrollOffset = !this.reverse ? (this.scrollOffset + 1) % text.length() : (this.scrollOffset - 1) % text.length();
            String checkText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
            if (textRenderer.method_1727(checkText) + 6 < maxWidth || this.scrollOffset < 1) {
                this.reverse = !this.reverse;
                this.effectCooldown = 90;
            }
            this.lastTime = currentTime;
        }
        String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
        return textRenderer.method_27523(scrollingText, maxWidth - textRenderer.method_1727("...")) + "...";
    }

    private String getScrollingText(String text, int scrollOffset, int maxWidth, class_327 textRenderer) {
        String visiblePart;
        if (scrollOffset < 0) {
            scrollOffset = 0;
        }
        if (scrollOffset > text.length()) {
            scrollOffset = text.length();
        }
        if (textRenderer.method_1727(visiblePart = text.substring(scrollOffset)) > maxWidth) {
            visiblePart = textRenderer.method_27523(visiblePart, maxWidth);
        }
        return visiblePart;
    }
}

