/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CopperUtils {
    public static BlockState tryDegrade(WeatheringCopper oxidizable, BlockState state) {
        Optional result = oxidizable.getNext(state);
        return result.orElse(state);
    }

    public static boolean isWaterNearby(BlockPos pos, LevelAccessor world) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        Direction[] directions = Direction.values();
        BlockState blockState = world.getBlockState((BlockPos)mutable);
        if (blockState.getFluidState().is((Fluid)Fluids.WATER)) {
            return true;
        }
        int sideCount = 0;
        for (Direction direction : directions) {
            mutable.setWithOffset((Vec3i)pos, direction);
            blockState = world.getBlockState((BlockPos)mutable);
            if (!blockState.getFluidState().is((Fluid)Fluids.WATER)) continue;
            ++sideCount;
        }
        return sideCount >= 4;
    }
}

