/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class NumberButton
extends EditBox {
    private final ConfigLoaderFromAnnotation.EntryInfo entryInfo;
    String MOD_ID;
    private boolean isFirstTime = true;

    public NumberButton(String MOD_ID, Font font, int width, int height, Component message, ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        super(font, width, height, message);
        this.entryInfo = entryInfo;
        this.MOD_ID = MOD_ID;
        this.setResponder(this::onTextChange);
        this.setHint((Component)Component.literal((String)"Number only"));
        try {
            Object object = entryInfo.targetField.get(null);
            this.setValue(object.toString());
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("Something went wrong with the Number button...");
            e.printStackTrace();
        }
    }

    public boolean charTyped(@NotNull CharacterEvent characterEvent) {
        if (!Character.isDigit(characterEvent.codepoint())) {
            return false;
        }
        return super.charTyped(characterEvent);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        try {
            Object object = this.entryInfo.targetField.get(null);
            if (!this.getValue().equals(object.toString()) || this.isFirstTime) {
                this.isFirstTime = false;
                this.setValue(object.toString());
            }
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("Something went wrong with the Number button...");
            e.printStackTrace();
        }
        if (this.isMouseOver(mouseX, mouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.setMessage((Component)Component.literal((String)this.entryInfo.humanizeName).withStyle(ChatFormatting.BOLD));
            MutableComponent info = Component.translatable((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.append((Component)Component.literal((String)"\n\n").append((Component)Component.translatable((String)(this.MOD_ID + ".config.require_restart")).withStyle(ChatFormatting.GOLD)));
            }
            ConfigScreen.infoTab_Info.setMessage((Component)info);
            ConfigScreen.infoTab.arrangeElements();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void onTextChange(String filter) {
        Field field = this.entryInfo.targetField;
        try {
            field.set(null, Integer.parseInt(filter));
        }
        catch (IllegalAccessException | NumberFormatException e) {
            Constants.LOG.error("Something went wrong with the config system...");
            e.printStackTrace();
        }
    }
}

