/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.network;

import club.mcams.carpet.network.AMS_CustomPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class PayloadHandlerChain {
    private final Map<Class<? extends AMS_CustomPayload>, CovariantHandlerList<?>> PAYLOAD_HANDLERS = new ConcurrentHashMap();

    public <T extends AMS_CustomPayload> void addHandlerFor(Class<T> payloadClass, Consumer<T> handler) {
        CovariantHandlerList<T> list = this.getOrCreate(payloadClass);
        list.addHandler(handler);
    }

    private <T extends AMS_CustomPayload> CovariantHandlerList<T> getOrCreate(Class<T> type) {
        CovariantHandlerList<?> existing = this.PAYLOAD_HANDLERS.get(type);
        if (existing != null) {
            return this.castList(existing, type);
        }
        CovariantHandlerList<T> newList = new CovariantHandlerList<T>(type);
        this.PAYLOAD_HANDLERS.put(type, newList);
        return newList;
    }

    private <T extends AMS_CustomPayload> CovariantHandlerList<T> castList(CovariantHandlerList<?> list, Class<T> type) {
        if (list.matchesType(type)) {
            return list.asType(type);
        }
        throw new IllegalStateException("Type mismatch");
    }

    public boolean handle(AMS_CustomPayload payload) {
        if (payload == null) {
            return false;
        }
        CovariantHandlerList<?> list = this.PAYLOAD_HANDLERS.get(payload.getClass());
        return list != null && list.handle(payload);
    }

    private static class CovariantHandlerList<T extends AMS_CustomPayload> {
        private final Class<T> type;
        private final List<Consumer<T>> handlers = new ArrayList<Consumer<T>>();

        CovariantHandlerList(Class<T> type) {
            this.type = type;
        }

        void addHandler(Consumer<T> handler) {
            this.handlers.add(handler);
        }

        boolean handle(AMS_CustomPayload payload) {
            if (!this.type.isInstance(payload)) {
                return false;
            }
            AMS_CustomPayload typed = (AMS_CustomPayload)this.type.cast(payload);
            for (Consumer<AMS_CustomPayload> consumer : this.handlers) {
                consumer.accept(typed);
            }
            return !this.handlers.isEmpty();
        }

        boolean matchesType(Class<? extends AMS_CustomPayload> otherType) {
            return this.type.equals(otherType);
        }

        <U extends AMS_CustomPayload> CovariantHandlerList<U> asType(Class<U> targetType) {
            if (!this.type.equals(targetType)) {
                throw new ClassCastException("Cannot cast " + this.type + " to " + targetType);
            }
            CovariantHandlerList<U> result = new CovariantHandlerList<U>(targetType);
            for (Consumer<T> handler : this.handlers) {
                result.addHandler(this.createBridgeConsumer(handler));
            }
            return result;
        }

        private <U extends AMS_CustomPayload> Consumer<U> createBridgeConsumer(Consumer<T> originalHandler) {
            return u -> {
                if (this.type.isInstance(u)) {
                    AMS_CustomPayload t = (AMS_CustomPayload)this.type.cast(u);
                    originalHandler.accept(t);
                }
            };
        }
    }
}

