/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.translations;

import carpet.CarpetSettings;
import club.mcams.carpet.AmsServer;
import club.mcams.carpet.mixin.translations.TranslatableTextAccessor;
import club.mcams.carpet.translations.ServerPlayerEntityWithClientLanguage;
import club.mcams.carpet.translations.TranslationConstants;
import club.mcams.carpet.utils.FileUtil;
import club.mcams.carpet.utils.Messenger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2554;
import net.minecraft.class_2588;
import net.minecraft.class_2590;
import net.minecraft.class_3222;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.byteeeee.yaml.TinyYamlParser;
import top.byteeeee.yaml.exception.YamlParseException;

public class AMSTranslations {
    private static final String LANG_DIR = String.format("assets/%s/lang", TranslationConstants.TRANSLATION_NAMESPACE);
    public static final Map<String, Map<String, String>> translations = Maps.newLinkedHashMap();
    public static final Set<String> languages = Sets.newHashSet();

    public static void loadTranslations() {
        try {
            List<String> availableLanguages = AMSTranslations.getAvailableLanguages();
            availableLanguages.forEach(language -> {
                try {
                    Map<String, String> translation = AMSTranslations.loadTranslationForLanguage(language);
                    translations.put((String)language, translation);
                    languages.add((String)language);
                }
                catch (IOException | YamlParseException e) {
                    AmsServer.LOGGER.warn("Failed to load translation for language: {}", language, (Object)e);
                }
            });
        }
        catch (IOException | YamlParseException e) {
            AmsServer.LOGGER.warn("Failed to get available languages", e);
        }
    }

    private static List<String> getAvailableLanguages() throws IOException, YamlParseException {
        String yamlData = FileUtil.readFile(LANG_DIR + "/meta/languages.yml");
        Map yamlMap = TinyYamlParser.parse((String)yamlData);
        ArrayList languagesObj = yamlMap.getOrDefault("languages", new ArrayList());
        if (languagesObj instanceof List) {
            return TinyYamlParser.getNestedStringList((Map)yamlMap, (String)"languages");
        }
        return new ArrayList<String>();
    }

    private static Map<String, String> loadTranslationForLanguage(String language) throws IOException, YamlParseException {
        String path = LANG_DIR + "/" + language + ".yml";
        String data = FileUtil.readFile(path);
        Map yaml = TinyYamlParser.parse((String)data);
        LinkedHashMap<String, String> translation = new LinkedHashMap<String, String>();
        AMSTranslations.buildTranslationMap(translation, yaml, "");
        return translation;
    }

    private static void buildTranslationMap(Map<String, String> translation, Map<String, Object> yaml, String prefix) {
        yaml.forEach((key, value) -> {
            String fullKey;
            String string = fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (value instanceof String) {
                translation.put(fullKey, (String)value);
            } else if (value instanceof Map) {
                AMSTranslations.buildTranslationMap(translation, (Map)value, fullKey);
            } else if (value == null) {
                translation.put(fullKey, "");
            } else {
                translation.put(fullKey, String.valueOf(value));
            }
        });
    }

    public static String getServerLanguage() {
        return CarpetSettings.language.equalsIgnoreCase("none") ? "en_us" : CarpetSettings.language;
    }

    @NotNull
    public static Map<String, String> getTranslation(String lang) {
        return translations.getOrDefault(lang, Collections.emptyMap());
    }

    @Nullable
    public static String translateKeyToFormattedString(String lang, String key) {
        return AMSTranslations.getTranslation(lang).get(key);
    }

    public static class_2554 translate(class_2554 text, class_3222 player) {
        if (player instanceof ServerPlayerEntityWithClientLanguage) {
            String lang = ((ServerPlayerEntityWithClientLanguage)player).getClientLanguage$AMS().toLowerCase();
            return AMSTranslations.translate(text, lang);
        }
        return text;
    }

    public static class_2554 translate(class_2554 text, String lang) {
        return AMSTranslations.translate(text, lang, false);
    }

    public static class_2554 translate(class_2554 text, String lang, boolean suppressWarnings) {
        if (!(text instanceof class_2588)) {
            return text;
        }
        class_2588 translatableText = (class_2588)text;
        String translationKey = translatableText.method_11022();
        if (!translationKey.startsWith(TranslationConstants.TRANSLATION_KEY_PREFIX)) {
            return text;
        }
        String formattedString = Optional.ofNullable(AMSTranslations.translateKeyToFormattedString(lang, translationKey)).orElseGet(() -> AMSTranslations.translateKeyToFormattedString("en_us", translationKey));
        return formattedString != null ? AMSTranslations.updateTextWithTranslation(text, formattedString, translatableText) : AMSTranslations.translationLog(translationKey, suppressWarnings, text);
    }

    private static class_2554 translationLog(String translationKey, boolean suppressWarnings, class_2554 text) {
        if (!suppressWarnings) {
            AmsServer.LOGGER.warn("Unknown translation key: {}. Check if the translation exists or the key is correct.", (Object)translationKey);
        }
        return text;
    }

    private static class_2554 updateTextWithTranslation(class_2554 originalText, String formattedString, class_2588 translatableText) {
        TranslatableTextAccessor fixedTranslatableText = (TranslatableTextAccessor)Messenger.tr(formattedString, translatableText.method_11023());
        class_2554 newText = AMSTranslations.createNewText(formattedString, fixedTranslatableText);
        if (newText == null) {
            return Messenger.s(formattedString);
        }
        newText.method_10855().addAll(originalText.method_10855());
        newText.method_10862(originalText.method_10866());
        return newText;
    }

    private static class_2554 createNewText(String formattedString, TranslatableTextAccessor fixedTranslatableText) {
        try {
            ArrayList translations = Lists.newArrayList();
            fixedTranslatableText.invokeSetTranslation(formattedString);
            class_2554[] textArray = new class_2554[translations.size()];
            for (int i = 0; i < translations.size(); ++i) {
                class_5348 stringVisitable = (class_5348)translations.get(i);
                textArray[i] = stringVisitable instanceof class_2554 ? (class_2554)stringVisitable : Messenger.s(stringVisitable.getString());
            }
            return Messenger.c(new Object[]{textArray});
        }
        catch (class_2590 e) {
            return null;
        }
    }
}

