/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.logging.logger;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.logging.AbstractHUDLogger;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.Messenger;
import java.time.Duration;
import java.time.Instant;
import net.minecraft.class_1657;
import net.minecraft.class_5250;

public class ServerRuntimeHUDLogger
extends AbstractHUDLogger {
    private static final Translator translator = new Translator("logger.serverRuntime");
    public static final String NAME = "serverRuntime";
    private static final ServerRuntimeHUDLogger INSTANCE = new ServerRuntimeHUDLogger();

    private ServerRuntimeHUDLogger() {
        super(NAME);
    }

    public static ServerRuntimeHUDLogger getInstance() {
        return INSTANCE;
    }

    @Override
    public class_5250[] onHudUpdate(String option, class_1657 playerEntity) {
        Instant currentTime = Instant.now();
        Instant serverStartTime = Instant.ofEpochMilli(AmsServer.serverStartTimeMillis);
        Duration elapsedDuration = Duration.between(serverStartTime, currentTime);
        long elapsedSeconds = elapsedDuration.getSeconds();
        long hours = elapsedSeconds / 3600L;
        long remainingSeconds = elapsedSeconds % 3600L;
        long minutes = remainingSeconds / 60L;
        long seconds = remainingSeconds % 60L;
        String formattedTime = String.format("%02d : %02d : %02d", hours, minutes, seconds);
        return new class_5250[]{Messenger.c(String.format("q %s ", translator.tr("server_runtime", new Object[0]).getString()), String.format("c %s", formattedTime))};
    }
}

