/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.mixin.rule.blockChunkLoader;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.helpers.rule.blockChunkLoader.BlockChunkLoaderHelper;
import club.mcams.carpet.utils.WorldUtil;
import java.util.Objects;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2665.class})
public abstract class PistonBlockMixin {
    @Inject(method={"onSyncedBlockEvent"}, at={@At(value="HEAD")})
    private void onSyncedBlockEvent(class_2680 state, class_1937 world, class_2338 pos, int type, int data, CallbackInfoReturnable<Boolean> cir) {
        if (!Objects.equals(AmsServerSettings.pistonBlockChunkLoader, "false")) {
            this.handleChunkLoading(state, world, pos);
        }
    }

    @Unique
    private void handleChunkLoading(class_2680 state, class_1937 world, class_2338 pos) {
        if (!WorldUtil.isClient(world)) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_2318.field_10927);
            class_2680 pistonBlockUp = world.method_8320(pos.method_10086(1));
            class_2680 pistonBlockDown = world.method_8320(pos.method_10087(1));
            class_1923 chunkPos = new class_1923(pos.method_10093(direction));
            if (this.optionIsBoneBlockOrAll()) {
                this.loadChunkIfMatch(world, chunkPos, pistonBlockUp, class_2246.field_10166);
            }
            if (this.optionIsBedRockOrAll()) {
                this.loadChunkIfMatch(world, chunkPos, pistonBlockDown, class_2246.field_9987);
            }
        }
    }

    @Unique
    private void loadChunkIfMatch(class_1937 world, class_1923 chunkPos, class_2680 blockState, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            if (blockState.method_26204() != block) continue;
            BlockChunkLoaderHelper.addPistonBlockTicket((class_3218)world, chunkPos);
            break;
        }
    }

    @Unique
    private boolean optionIsBoneBlockOrAll() {
        return Objects.equals(AmsServerSettings.pistonBlockChunkLoader, "bone_block") || Objects.equals(AmsServerSettings.pistonBlockChunkLoader, "all");
    }

    @Unique
    private boolean optionIsBedRockOrAll() {
        return Objects.equals(AmsServerSettings.pistonBlockChunkLoader, "bedrock") || Objects.equals(AmsServerSettings.pistonBlockChunkLoader, "all");
    }
}

