/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.settings;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.SettingsManager;
import club.mcams.carpet.AmsServer;
import club.mcams.carpet.settings.Rule;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public class CarpetRuleRegistrar {
    private final SettingsManager settingsManager;
    private final List<CarpetRule<?>> rules = Lists.newArrayList();

    private CarpetRuleRegistrar(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public static void register(SettingsManager settingsManager, Class<?> settingsClass) {
        CarpetRuleRegistrar registrar = new CarpetRuleRegistrar(settingsManager);
        registrar.parseSettingsClass(settingsClass);
        registrar.registerToCarpet();
    }

    private void parseSettingsClass(Class<?> settingsClass) {
        for (Field field : settingsClass.getDeclaredFields()) {
            Rule rule = field.getAnnotation(Rule.class);
            if (rule == null) continue;
            this.parseRule(field, rule);
        }
    }

    private void parseRule(Field field, Rule rule) {
        try {
            Class<?> ruleAnnotationClass = Class.forName("carpet.settings.ParsedRule$RuleAnnotation");
            Constructor<?> ctr1 = ruleAnnotationClass.getDeclaredConstructors()[0];
            ctr1.setAccessible(true);
            Object ruleAnnotation = ctr1.newInstance(false, null, null, null, rule.categories(), rule.options(), rule.strict(), "", rule.validators());
            Class<?> parsedRuleClass = Class.forName("carpet.settings.ParsedRule");
            Constructor ctr2 = Arrays.stream(parsedRuleClass.getDeclaredConstructors()).filter(ctr -> ctr.getParameterTypes().length == 3).filter(ctr -> ctr.getParameterTypes()[0] == Field.class).filter(ctr -> ctr.getParameterTypes()[1].isAssignableFrom(ruleAnnotationClass)).filter(ctr -> ctr.getParameterTypes()[2] == SettingsManager.class).findFirst().orElseThrow(() -> new NoSuchMethodException("Failed to get matched ParsedRule constructor"));
            ctr2.setAccessible(true);
            Object carpetRule = ctr2.newInstance(field, ruleAnnotation, this.settingsManager);
            if (!(carpetRule instanceof CarpetRule)) {
                throw new ClassCastException("Failed to cast to CarpetRule.");
            }
            this.rules.add((CarpetRule)carpetRule);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Reflection error: " + e.getMessage(), e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new RuntimeException("Instantiation error: " + e.getMessage(), e);
        }
    }

    private void registerToCarpet() {
        for (CarpetRule<?> rule : this.rules) {
            try {
                this.settingsManager.addCarpetRule(rule);
            }
            catch (UnsupportedOperationException e) {
                AmsServer.LOGGER.warn("Failed to register rule {} to fabric carpet: {}", (Object)rule.name(), (Object)e);
            }
        }
    }
}

