/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.network;

import club.mcams.carpet.network.AMS_CustomPayload;
import club.mcams.carpet.network.PayloadHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class PayloadHandlerChain {
    private final List<PayloadHandler> handlers = new ArrayList<PayloadHandler>();

    public void addHandler(PayloadHandler handler) {
        this.handlers.add(handler);
    }

    public boolean handle(AMS_CustomPayload payload) {
        for (PayloadHandler handler : this.handlers) {
            if (!handler.handle(payload)) continue;
            return true;
        }
        return false;
    }

    public <T extends AMS_CustomPayload> void addHandlerFor(Class<T> payloadClass, Consumer<T> handler) {
        this.addHandler(payload -> {
            if (payloadClass.isInstance(payload)) {
                handler.accept((AMS_CustomPayload)payloadClass.cast(payload));
                return true;
            }
            return false;
        });
    }
}

