/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandPlayerNoNetherPortalTeleport;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.PlayerUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;

public class PlayerNoNetherPortalTeleportRegistry {
    public static final Set<class_1657> NO_NETHER_PORTAL_TELEPORT_SET = new LinkedHashSet<class_1657>();
    public static boolean isGlobalMode;
    private static final Translator tr;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"playerNoNetherPortalTeleport").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandPlayerNoNetherPortalTeleport))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"globalMode").executes(c -> PlayerNoNetherPortalTeleportRegistry.showGlobalModeState((class_2168)c.getSource()))).then(class_2170.method_9244((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(c -> PlayerNoNetherPortalTeleportRegistry.setGlobalMode(c, (class_2168)c.getSource()))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> PlayerNoNetherPortalTeleportRegistry.add((class_2168)c.getSource(), (class_1657)class_2186.method_9315((CommandContext)c, (String)"player")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> PlayerNoNetherPortalTeleportRegistry.remove((class_2168)c.getSource(), (class_1657)class_2186.method_9315((CommandContext)c, (String)"player")))))).then(class_2170.method_9247((String)"clear").executes(c -> PlayerNoNetherPortalTeleportRegistry.clear((class_2168)c.getSource())))).then(class_2170.method_9247((String)"list").executes(c -> PlayerNoNetherPortalTeleportRegistry.list((class_2168)c.getSource())))).then(class_2170.method_9247((String)"help").executes(c -> PlayerNoNetherPortalTeleportRegistry.help((class_2168)c.getSource()))));
    }

    private static int add(class_2168 source, class_1657 player) {
        if (!NO_NETHER_PORTAL_TELEPORT_SET.contains(player)) {
            NO_NETHER_PORTAL_TELEPORT_SET.add(player);
            Messenger.tell(source, tr.tr("add_success", PlayerUtil.getName(player)).method_27692(class_124.field_1060));
            return 1;
        }
        Messenger.tell(source, tr.tr("add_fail", PlayerUtil.getName(player)).method_27692(class_124.field_1054));
        return 0;
    }

    private static int remove(class_2168 source, class_1657 player) {
        if (NO_NETHER_PORTAL_TELEPORT_SET.contains(player)) {
            NO_NETHER_PORTAL_TELEPORT_SET.remove(player);
            Messenger.tell(source, tr.tr("remove_success", PlayerUtil.getName(player)).method_27692(class_124.field_1060));
            return 1;
        }
        Messenger.tell(source, tr.tr("remove_fail", PlayerUtil.getName(player)).method_27692(class_124.field_1054));
        return 0;
    }

    private static int clear(class_2168 source) {
        if (NO_NETHER_PORTAL_TELEPORT_SET.isEmpty()) {
            Messenger.tell(source, tr.tr("clear_fail", new Object[0]).method_27692(class_124.field_1054));
            return 0;
        }
        NO_NETHER_PORTAL_TELEPORT_SET.clear();
        Messenger.tell(source, tr.tr("clear_success", new Object[0]).method_27692(class_124.field_1060));
        return 1;
    }

    private static int list(class_2168 source) {
        Messenger.tell(source, tr.tr("list_title", new Object[0]).method_27692(class_124.field_1075));
        Messenger.tell(source, Messenger.s("======================================", class_124.field_1075));
        for (class_1657 player : NO_NETHER_PORTAL_TELEPORT_SET) {
            Messenger.tell(source, Messenger.s(PlayerUtil.getName(player), class_124.field_1075));
        }
        return 1;
    }

    private static int setGlobalMode(CommandContext<?> context, class_2168 source) {
        isGlobalMode = BoolArgumentType.getBool(context, (String)"bool");
        if (isGlobalMode) {
            Messenger.tell(source, tr.tr("globalMode_enable", new Object[0]).method_27692(class_124.field_1060));
        } else {
            Messenger.tell(source, tr.tr("globalMode_disable", new Object[0]).method_27692(class_124.field_1060));
        }
        return 1;
    }

    private static int showGlobalModeState(class_2168 source) {
        String globalModeState = isGlobalMode ? "true" : "false";
        Messenger.tell(source, tr.tr("globalMode_state", globalModeState).method_27692(class_124.field_1075));
        return 1;
    }

    private static int help(class_2168 source) {
        Messenger.tell(source, Messenger.c(tr.tr("help.globalMode", new Object[0]), Messenger.endl(), tr.tr("help.globalModeState", new Object[0]), Messenger.endl(), tr.tr("help.add", new Object[0]), Messenger.endl(), tr.tr("help.remove", new Object[0]), Messenger.endl(), tr.tr("help.clear", new Object[0]), Messenger.endl(), tr.tr("help.list", new Object[0])).method_27692(class_124.field_1080));
        return 1;
    }

    static {
        tr = new Translator("command.playerNoNetherPortalTeleport");
    }
}

