/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.utils;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.commands.rule.commandCustomCommandPermissionLevel.CustomCommandPermissionLevelRegistry;
import club.mcams.carpet.mixin.rule.commandCustomCommandPermissionLevel.CommandNodeInvoker;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public final class CommandHelper {
    public static final List<String> permissionLevels = Arrays.asList("0", "1", "2", "3", "4");
    private static final Translator translator = new Translator("command.commandHelper");

    private CommandHelper() {
    }

    public static void updateAllCommandPermissions(MinecraftServer server) {
        if (!Objects.equals(AmsServerSettings.commandCustomCommandPermissionLevel, "false")) {
            CommandDispatcher dispatcher = server.method_3734().method_9235();
            class_2170 serverCommandManager = server.method_3734();
            for (CommandNode node : dispatcher.getRoot().getChildren()) {
                if (!(node instanceof LiteralCommandNode)) continue;
                String commandName = ((LiteralCommandNode)node).getLiteral();
                Predicate<class_2168> defaultRequirement = CustomCommandPermissionLevelRegistry.DEFAULT_PERMISSION_MAP.get(commandName);
                if (CustomCommandPermissionLevelRegistry.COMMAND_PERMISSION_MAP.containsKey(commandName)) {
                    int level = CustomCommandPermissionLevelRegistry.COMMAND_PERMISSION_MAP.get(commandName);
                    ((CommandNodeInvoker)node).setRequirement(source -> CommandHelper.hasPermissionLevel(source, level));
                    continue;
                }
                if (defaultRequirement == null) continue;
                ((CommandNodeInvoker)node).setRequirement(defaultRequirement);
            }
            server.method_3760().method_14571().forEach(arg_0 -> ((class_2170)serverCommandManager).method_9241(arg_0));
            Messenger.sendServerMessage(server, (class_2561)Messenger.s("\u00a7o\u00a77Server: " + translator.tr("refresh_cmd_tree", new Object[0]).getString()));
        }
    }

    public static void setPermission(MinecraftServer server, String command, int permissionLevel) {
        CommandDispatcher dispatcher = server.method_3734().method_9235();
        CommandNode target = dispatcher.getRoot().getChild(command);
        if (target != null) {
            ((CommandNodeInvoker)target).setRequirement(source -> CommandHelper.hasPermissionLevel(source, permissionLevel));
        }
    }

    public static boolean canUseCommand(class_2168 source, Object commandLevel) {
        if (commandLevel instanceof Boolean) {
            return (Boolean)commandLevel;
        }
        if (commandLevel instanceof String) {
            char c;
            String levelStr;
            switch (levelStr = ((String)commandLevel).toLowerCase(Locale.ENGLISH)) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
                case "ops": {
                    return CommandHelper.hasPermissionLevel(source, 2);
                }
            }
            if (levelStr.length() == 1 && (c = levelStr.charAt(0)) >= '0' && c <= '4') {
                return CommandHelper.hasPermissionLevel(source, c - 48);
            }
        }
        return false;
    }

    public static boolean hasPermissionLevel(class_2168 source, int level) {
        return source.method_9259(level);
    }
}

