/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.yaml;

import club.mcams.carpet.yaml.YamlParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlParser {
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("^(\\s*)(['\"]?\\S[^:]*?['\"]?)\\s*:\\s*(.*)$");
    private static final Pattern LIST_ITEM_PATTERN = Pattern.compile("^(\\s*)-\\s+(.*)$");
    private static final Pattern QUOTED_STRING_PATTERN = Pattern.compile("^[\"'](.*)[\"']$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^-?\\d+(\\.\\d+)?$");
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("^(true|false)$", 2);

    private static String removeQuotes(String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        char first = str.charAt(0);
        char last = str.charAt(str.length() - 1);
        if (first == '\"' && last == '\"' || first == '\'' && last == '\'') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static Map<String, Object> parse(String content) throws IOException, YamlParseException {
        try (StringReader reader = new StringReader(content);){
            Map<String, Object> map = YamlParser.parse(reader);
            return map;
        }
    }

    public static Map<String, Object> parse(Reader reader) throws IOException, YamlParseException {
        String line;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
            lines.add(line);
        }
        YamlParser.parseNode(lines, 0, 0, result);
        return result;
    }

    private static int parseNode(List<String> lines, int startIndex, int baseIndentation, Map<String, Object> container) throws YamlParseException {
        int i = startIndex;
        while (i < lines.size()) {
            String line = lines.get(i);
            int indentation = YamlParser.countIndentation(line);
            if (indentation < baseIndentation && i > startIndex) {
                return i;
            }
            Matcher keyValueMatcher = KEY_VALUE_PATTERN.matcher(line);
            if (keyValueMatcher.matches()) {
                String keyWithQuotes = keyValueMatcher.group(2);
                String key = YamlParser.removeQuotes(keyWithQuotes);
                String value = keyValueMatcher.group(3);
                if (value.isEmpty()) {
                    if (++i < lines.size() && YamlParser.countIndentation(lines.get(i)) > indentation) {
                        if (lines.get(i).trim().startsWith("-")) {
                            ArrayList<Object> list = new ArrayList<Object>();
                            i = YamlParser.parseList(lines, i, indentation + 2, list);
                            container.put(key, list);
                            continue;
                        }
                        LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                        i = YamlParser.parseNode(lines, i, indentation + 2, nestedMap);
                        container.put(key, nestedMap);
                        continue;
                    }
                    container.put(key, "");
                    continue;
                }
                container.put(key, YamlParser.parseValue(value));
                ++i;
                continue;
            }
            Matcher listItemMatcher = LIST_ITEM_PATTERN.matcher(line);
            if (listItemMatcher.matches() && indentation == baseIndentation) {
                throw new YamlParseException("Unexpected list item, line number:" + (i + 1));
            }
            ++i;
        }
        return i;
    }

    private static int parseList(List<String> lines, int startIndex, int baseIndentation, List<Object> list) throws YamlParseException {
        int i = startIndex;
        while (i < lines.size()) {
            String line = lines.get(i);
            int indentation = YamlParser.countIndentation(line);
            if (indentation < baseIndentation) {
                return i;
            }
            Matcher listItemMatcher = LIST_ITEM_PATTERN.matcher(line);
            if (listItemMatcher.matches() && indentation == baseIndentation) {
                String value = listItemMatcher.group(2);
                if (value.isEmpty()) {
                    if (++i < lines.size() && YamlParser.countIndentation(lines.get(i)) > indentation) {
                        if (lines.get(i).trim().startsWith("-")) {
                            ArrayList<Object> nestedList = new ArrayList<Object>();
                            i = YamlParser.parseList(lines, i, indentation + 2, nestedList);
                            list.add(nestedList);
                            continue;
                        }
                        LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                        i = YamlParser.parseNode(lines, i, indentation + 2, nestedMap);
                        list.add(nestedMap);
                        continue;
                    }
                    list.add("");
                    continue;
                }
                list.add(YamlParser.parseValue(value));
                ++i;
                continue;
            }
            if (indentation > baseIndentation) {
                ++i;
                continue;
            }
            return i;
        }
        return i;
    }

    private static Object parseValue(String valueStr) {
        if (valueStr == null || valueStr.isEmpty()) {
            return "";
        }
        String trimmedValue = valueStr.trim();
        Matcher quotedMatcher = QUOTED_STRING_PATTERN.matcher(trimmedValue);
        if (quotedMatcher.matches()) {
            return quotedMatcher.group(1);
        }
        Matcher booleanMatcher = BOOLEAN_PATTERN.matcher(trimmedValue);
        if (booleanMatcher.matches()) {
            return Boolean.parseBoolean(trimmedValue.toLowerCase());
        }
        Matcher numberMatcher = NUMBER_PATTERN.matcher(trimmedValue);
        if (numberMatcher.matches()) {
            if (trimmedValue.contains(".")) {
                return Double.parseDouble(trimmedValue);
            }
            return Integer.parseInt(trimmedValue);
        }
        if (trimmedValue.equalsIgnoreCase("null") || trimmedValue.equals("~")) {
            return null;
        }
        return trimmedValue;
    }

    private static int countIndentation(String line) {
        int count;
        for (count = 0; count < line.length() && line.charAt(count) == ' '; ++count) {
        }
        return count;
    }

    public static String dump(Map<String, Object> data) {
        StringBuilder builder = new StringBuilder();
        YamlParser.writeMap(data, "", builder);
        return builder.toString();
    }

    private static void writeMap(Map<String, Object> map, String indent, StringBuilder builder) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            builder.append(indent).append(entry.getKey()).append(":");
            YamlParser.writeValue(entry.getValue(), indent, builder);
        }
    }

    private static void writeList(List<?> list, String indent, StringBuilder builder) {
        for (Object item : list) {
            builder.append(indent).append("- ");
            if (item instanceof Map) {
                Map map = (Map)item;
                if (map.isEmpty()) {
                    builder.append("{}\n");
                    continue;
                }
                builder.append("\n");
                YamlParser.writeMap(map, indent + "  ", builder);
                continue;
            }
            if (item instanceof List) {
                List nestedList = (List)item;
                if (nestedList.isEmpty()) {
                    builder.append("[]\n");
                    continue;
                }
                builder.append("\n");
                YamlParser.writeList(nestedList, indent + "  ", builder);
                continue;
            }
            YamlParser.writeScalar(item, builder);
            builder.append("\n");
        }
    }

    private static void writeValue(Object value, String indent, StringBuilder builder) {
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                builder.append(" {}\n");
            } else {
                builder.append("\n");
                YamlParser.writeMap(map, indent + "  ", builder);
            }
        } else if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                builder.append(" []\n");
            } else {
                builder.append("\n");
                YamlParser.writeList(list, indent + "  ", builder);
            }
        } else {
            builder.append(" ");
            YamlParser.writeScalar(value, builder);
            builder.append("\n");
        }
    }

    private static void writeScalar(Object value, StringBuilder builder) {
        if (value == null) {
            builder.append("null");
        } else if (value instanceof String) {
            String str = (String)value;
            if (YamlParser.needsQuoting(str)) {
                builder.append("\"").append(YamlParser.escapeString(str)).append("\"");
            } else {
                builder.append(str);
            }
        } else {
            builder.append(value);
        }
    }

    private static boolean needsQuoting(String str) {
        if (str.isEmpty()) {
            return true;
        }
        char firstChar = str.charAt(0);
        if ("&*-!|>%@`".indexOf(firstChar) >= 0 || Character.isDigit(firstChar) || firstChar == '?' || firstChar == ':') {
            return true;
        }
        if (str.contains(":") || str.contains("#") || str.contains("\n") || str.trim().isEmpty() || str.contains("\"") || str.contains("'")) {
            return true;
        }
        return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false") || str.equalsIgnoreCase("null") || str.equals("~") || NUMBER_PATTERN.matcher(str).matches();
    }

    private static String escapeString(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    @Nullable
    public static Object getNestedValue(Map<String, Object> map, String path) {
        String[] parts = path.split("\\.");
        Object current = map;
        for (String part : parts) {
            if (current instanceof Map) {
                Object currentMap = current;
                if ((current = currentMap.get(part)) != null) continue;
                return null;
            }
            return null;
        }
        return current;
    }

    @Nullable
    public static String getNestedString(Map<String, Object> map, String path) {
        Object value = YamlParser.getNestedValue(map, path);
        return value instanceof String ? (String)value : null;
    }

    @NotNull
    public static List<String> getNestedStringList(Map<String, Object> map, String path) {
        Object value = YamlParser.getNestedValue(map, path);
        if (value instanceof List) {
            List listValue = (List)value;
            ArrayList<String> result = new ArrayList<String>();
            for (Object item : listValue) {
                if (!(item instanceof String)) continue;
                result.add((String)item);
            }
            return result;
        }
        return new ArrayList<String>();
    }
}

