/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.api.recipe.template;

import club.mcams.carpet.api.recipe.template.RecipeTemplateInterface;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.class_2960;

public class ShapedRecipeTemplate
implements RecipeTemplateInterface {
    private final class_2960 recipeId;
    private final String[][] pattern;
    private final Map<Character, String> ingredients;
    private final String resultItem;
    private final int resultCount;

    public ShapedRecipeTemplate(class_2960 recipeId, String[][] pattern, Map<Character, String> ingredients, String resultItem, int resultCount) {
        this.recipeId = recipeId;
        this.pattern = pattern;
        this.ingredients = ingredients;
        this.resultItem = resultItem;
        this.resultCount = resultCount;
    }

    @Override
    public JsonObject toJson() {
        JsonObject recipeJson = new JsonObject();
        recipeJson.addProperty("type", "minecraft:crafting_shaped");
        JsonArray patternJson = new JsonArray();
        for (String[] row : this.pattern) {
            StringBuilder rowString = new StringBuilder();
            for (String cell : row) {
                rowString.append(cell);
            }
            patternJson.add(rowString.toString());
        }
        recipeJson.add("pattern", (JsonElement)patternJson);
        JsonObject keyJson = new JsonObject();
        for (Map.Entry<Character, String> entry : this.ingredients.entrySet()) {
            keyJson.addProperty(entry.getKey().toString(), entry.getValue());
        }
        recipeJson.add("key", (JsonElement)keyJson);
        JsonObject resultJson = new JsonObject();
        resultJson.addProperty("id", this.resultItem);
        resultJson.addProperty("count", (Number)this.resultCount);
        recipeJson.add("result", (JsonElement)resultJson);
        return recipeJson;
    }

    @Override
    public void addToRecipeMap(Map<class_2960, JsonElement> recipeMap) {
        recipeMap.put(this.recipeId, (JsonElement)this.toJson());
    }
}

