/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.network.payloads.handshake;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.AmsServerMod;
import club.mcams.carpet.network.AMS_CustomPayload;
import club.mcams.carpet.network.AMS_PayloadManager;
import club.mcams.carpet.utils.NetworkUtil;
import club.mcams.carpet.utils.PlayerUtil;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class HandShakeC2SPayload
extends AMS_CustomPayload {
    private static final String ID = AMS_PayloadManager.PacketId.HANDSHAKE_C2S.getId();
    private final String modVersion;
    private final UUID playerUuid;

    private HandShakeC2SPayload(String modVersion, UUID playerUuid) {
        super(ID);
        this.modVersion = modVersion;
        this.playerUuid = playerUuid;
    }

    private HandShakeC2SPayload(class_2540 buf) {
        super(ID);
        this.modVersion = buf.method_19772();
        this.playerUuid = buf.method_10790();
    }

    @Override
    protected void writeData(class_2540 buf) {
        buf.method_10814(this.modVersion);
        buf.method_10797(this.playerUuid);
    }

    @Override
    public void handle() {
        NetworkUtil.executeOnServerThread(() -> {
            String playerName;
            class_3222 player = PlayerUtil.getServerPlayerEntity(this.playerUuid);
            String string = playerName = player != null ? PlayerUtil.getName((class_1657)player) : "Unknown Player";
            if (this.modVersion.equals(AmsServerMod.getVersion())) {
                AmsServer.LOGGER.info("{} joined with matched carpet-ams-addition v{}", (Object)playerName, (Object)this.modVersion);
            } else {
                AmsServer.LOGGER.info("{} joined with mismatched carpet-ams-addition version (client: v{}, server: v{})", (Object)playerName, (Object)this.modVersion, (Object)AmsServerMod.getVersion());
            }
            NetworkUtil.addSupportClient(this.playerUuid);
            if (player != null) {
                AmsServer.getInstance().sendS2CPacketOnHandShake(player);
            } else {
                AmsServer.LOGGER.warn("Could not find player entity for UUID: {}", (Object)this.playerUuid);
            }
        });
    }

    public static HandShakeC2SPayload create(String modVersion, UUID playerUuid) {
        return new HandShakeC2SPayload(modVersion, playerUuid);
    }

    public static void register() {
        AMS_PayloadManager.register(ID, HandShakeC2SPayload::new);
    }
}

