/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.network.payloads.handshake;

import club.mcams.carpet.AmsClient;
import club.mcams.carpet.network.AMS_CustomPayload;
import club.mcams.carpet.network.AMS_PayloadManager;
import club.mcams.carpet.utils.NetworkUtil;
import net.minecraft.class_2540;

public class HandShakeS2CPayload
extends AMS_CustomPayload {
    private static final String ID = AMS_PayloadManager.PacketId.HANDSHAKE_S2C.getId();
    private final String modVersion;
    private final boolean isSupportServer;

    private HandShakeS2CPayload(String modVersion, boolean isSupportServer) {
        super(ID);
        this.modVersion = modVersion;
        this.isSupportServer = isSupportServer;
    }

    private HandShakeS2CPayload(class_2540 buf) {
        super(ID);
        this.modVersion = buf.method_19772();
        this.isSupportServer = buf.readBoolean();
    }

    @Override
    protected void writeData(class_2540 buf) {
        buf.method_10814(this.modVersion);
        buf.method_52964(this.isSupportServer);
    }

    @Override
    public void handle() {
        NetworkUtil.executeOnClientThread(() -> {
            if (this.modVersion.equals(AmsClient.getVersion())) {
                AmsClient.LOGGER.info("You joined server with matched carpet-ams-addition v{}", (Object)this.modVersion);
            } else {
                AmsClient.LOGGER.info("You joined server with mismatched carpet-ams-addition version (client: v{}, server: v{})", (Object)AmsClient.getVersion(), (Object)this.modVersion);
            }
            NetworkUtil.setServerSupport(this.isSupportServer);
        });
    }

    public static HandShakeS2CPayload create(String modVersion, boolean isSupportServer) {
        return new HandShakeS2CPayload(modVersion, isSupportServer);
    }

    public static void register() {
        AMS_PayloadManager.register(ID, HandShakeS2CPayload::new);
    }
}

