/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandPacketInternetGroper;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class PingCommandRegistry {
    private static final Translator translator = new Translator("command.ping");
    private static final String MSG_HEAD = "<commandPacketInternetGroper>";
    private static final Map<class_1657, PingThread> PING_THREADS = new HashMap<class_1657, PingThread>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pings").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandPacketInternetGroper))).then(class_2170.method_9244((String)"targetIpOrDomainName", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"pingQuantity", (ArgumentType)IntegerArgumentType.integer()).executes(context -> PingCommandRegistry.executePing((class_1657)((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"targetIpOrDomainName"), IntegerArgumentType.getInteger((CommandContext)context, (String)"pingQuantity")))))).then(class_2170.method_9247((String)"stop").executes(context -> PingCommandRegistry.stopPing((class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"help").executes(context -> PingCommandRegistry.help((class_1657)((class_2168)context.getSource()).method_9207()))));
    }

    private static int executePing(class_1657 player, String targetIpOrDomainName, int pingQuantity) {
        PingThread thread = PING_THREADS.get(player);
        if (thread != null) {
            thread.setInterrupted();
        }
        PingThread pingThread = new PingThread(pingQuantity, player, targetIpOrDomainName);
        pingThread.start();
        PING_THREADS.put(player, pingThread);
        return 1;
    }

    private static long ping(class_1657 player, String targetIpOrDomainName, boolean isFirstPing) {
        try {
            InetAddress inetAddress = InetAddress.getByName(targetIpOrDomainName);
            if (isFirstPing) {
                player.method_7353((class_2561)Messenger.s(String.format("\u00a7b%s \u00a7ePing \u00a7b%s \u00a7e[ %s ] \u00a7e...", MSG_HEAD, targetIpOrDomainName, inetAddress.getHostAddress())), false);
            }
            long startTime = System.currentTimeMillis();
            boolean isReachable = inetAddress.isReachable(5000);
            long endTime = System.currentTimeMillis();
            if (isReachable) {
                long delayTime = endTime - startTime;
                player.method_7353((class_2561)Messenger.s(String.format("\u00a7b%s \u00a72Replay from \u00a7e[ %s ]\u00a72 Time = %dms", MSG_HEAD, inetAddress.getHostAddress(), delayTime)), false);
                return delayTime;
            }
            player.method_7353((class_2561)Messenger.s(String.format("\u00a7b%s \u00a74Request time out.", MSG_HEAD)), false);
            return -1L;
        }
        catch (IOException e) {
            AmsServer.LOGGER.error("[commandPing] An error occurred while performing ping operation");
            return -1L;
        }
    }

    private static int stopPing(class_1657 player) {
        String stopPing = translator.tr("stop_ping", new Object[0]).getString();
        String activePingIsNull = translator.tr("active_ping_is_null", new Object[0]).getString();
        PingThread pingThread = PING_THREADS.get(player);
        if (pingThread != null) {
            pingThread.setInterrupted();
            player.method_7353((class_2561)Messenger.s(String.format("\u00a7b%s \u00a74%s", MSG_HEAD, stopPing)), false);
        } else {
            player.method_7353((class_2561)Messenger.s(String.format("\u00a7b%s \u00a74%s", MSG_HEAD, activePingIsNull)), false);
        }
        return 1;
    }

    private static int help(class_1657 player) {
        String pingHelp = translator.tr("help.ping", new Object[0]).getString();
        String stopHelp = translator.tr("help.stop", new Object[0]).getString();
        player.method_7353((class_2561)Messenger.s(pingHelp + "\n" + stopHelp).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)), false);
        return 1;
    }

    private static void sendFinishMessage(class_1657 player, int totalPings, int successfulPings, int failedPings, long averageDelay) {
        player.method_7353((class_2561)Messenger.s(String.format("\u00a7b%s \u00a7aSent = %d, Received = %d, Lost = %d, Average delay = %dms", MSG_HEAD, totalPings, successfulPings, failedPings, averageDelay)), false);
    }

    private static class PingThread
    extends Thread {
        private volatile boolean interrupted = false;
        private final int pingQuantity;
        private final class_1657 player;
        private final String targetIpOrDomainName;

        private PingThread(int pingQuantity, class_1657 player, String targetIpOrDomainName) {
            this.pingQuantity = pingQuantity;
            this.player = player;
            this.targetIpOrDomainName = targetIpOrDomainName;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int successfulPings = 0;
            int failedPings = 0;
            long totalDelay = 0L;
            try {
                boolean isFirstPing = true;
                for (int i = 0; i < this.pingQuantity; ++i) {
                    if (this.interrupted) {
                        return;
                    }
                    long delay = PingCommandRegistry.ping(this.player, this.targetIpOrDomainName, isFirstPing);
                    if (delay >= 0L) {
                        ++successfulPings;
                        totalDelay += delay;
                    } else {
                        ++failedPings;
                    }
                    isFirstPing = false;
                    Thread.sleep(1000L);
                }
                PingCommandRegistry.sendFinishMessage(this.player, this.pingQuantity, successfulPings, failedPings, successfulPings > 0 ? totalDelay / (long)successfulPings : 0L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                PING_THREADS.remove(this.player);
            }
        }

        private void setInterrupted() {
            this.interrupted = true;
        }
    }
}

