/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.config.rule.commandCustomBlockBlastResistance;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.config.template.AbstractMapJsonConfig;
import club.mcams.carpet.utils.IdentifierUtil;
import club.mcams.carpet.utils.MinecraftServerUtil;
import club.mcams.carpet.utils.RegexTools;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class CustomBlockBlastResistanceConfig
extends AbstractMapJsonConfig<String, Float> {
    private static final CustomBlockBlastResistanceConfig INSTANCE = new CustomBlockBlastResistanceConfig();

    public CustomBlockBlastResistanceConfig() {
        super(CustomBlockBlastResistanceConfig.getConfigPath(MinecraftServerUtil.getServer()));
    }

    public static CustomBlockBlastResistanceConfig getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<String> getKeyType() {
        return String.class;
    }

    @Override
    protected Class<Float> getValueType() {
        return Float.class;
    }

    public void loadBlockStates(Map<class_2680, Float> targetMap) {
        HashMap<String, Float> storageMap = new HashMap<String, Float>();
        super.loadFromJson(storageMap);
        targetMap.clear();
        storageMap.forEach((blockId, resistance) -> {
            try {
                class_2680 state = ((class_2248)class_7923.field_41175.method_10223(IdentifierUtil.ofId(blockId))).method_9564();
                if (state != null) {
                    targetMap.put(state, (Float)resistance);
                }
            }
            catch (Exception e) {
                AmsServer.LOGGER.error("Invalid block ID: {}", blockId, (Object)e);
            }
        });
    }

    public void saveBlockStates(Map<class_2680, Float> sourceMap) {
        HashMap storageMap = new HashMap();
        sourceMap.forEach((state, resistance) -> {
            String blockId = RegexTools.getBlockRegisterName(state.method_26204().toString());
            storageMap.put(blockId, resistance);
        });
        this.saveToJson(storageMap);
    }

    private static Path getConfigPath(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("carpetamsaddition/custom_block_blast_resistance.json");
    }
}

