/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.helpers.rule.recipeRule;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.AmsServerCustomRecipes;
import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.api.recipe.AmsRecipeBuilder;
import club.mcams.carpet.api.recipe.AmsRecipeManager;
import club.mcams.carpet.settings.RecipeRule;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1863;
import net.minecraft.class_3222;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;

public class RecipeRuleHelper {
    private static final String MOD_ID = AmsServer.compactName;

    public static void onPlayerLoggedIn(MinecraftServer server, class_3222 player) {
        if (server != null && server.method_3806() && RecipeRuleHelper.hasActiveRecipeRule()) {
            Collection allRecipes = RecipeRuleHelper.getServerRecipeManager(server).method_8126();
            for (class_8786 recipe : allRecipes) {
                if (!recipe.comp_1932().method_12836().equals(MOD_ID) || player.method_14253().method_22845(recipe.comp_1932())) continue;
                player.method_7254(List.of(recipe));
            }
        }
    }

    public static void onValueChange(MinecraftServer server) {
        if (server != null && server.method_3806()) {
            AmsRecipeManager.clearRecipeListMemory(AmsRecipeBuilder.getInstance());
            AmsServerCustomRecipes.getInstance().buildRecipes();
            server.execute(() -> {
                RecipeRuleHelper.needReloadServerResources(server);
                Collection allRecipes = RecipeRuleHelper.getServerRecipeManager(server).method_8126();
                for (class_8786 recipe : allRecipes) {
                    if (!recipe.comp_1932().method_12836().equals(MOD_ID)) continue;
                    for (class_3222 player : server.method_3760().method_14571()) {
                        if (player.method_14253().method_22845(recipe.comp_1932())) continue;
                        player.method_7254(List.of(recipe));
                    }
                }
            });
        }
    }

    private static boolean hasActiveRecipeRule() {
        Field[] fields;
        for (Field field : fields = AmsServerSettings.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(RecipeRule.class)) continue;
            try {
                field.setAccessible(true);
                if (!field.getBoolean(null)) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                AmsServer.LOGGER.warn("Failed to access RecipeRule field: {}", (Object)field.getName(), (Object)e);
            }
        }
        return false;
    }

    private static class_1863 getServerRecipeManager(MinecraftServer server) {
        return server.method_3772();
    }

    public static void needReloadServerResources(MinecraftServer server) {
        if (server != null && server.method_3806() && RecipeRuleHelper.hasActiveRecipeRule()) {
            server.method_29439(server.method_3836().method_29210());
        }
    }
}

