/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.config.rule.welcomeMessage;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.Messenger;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class CustomWelcomeMessageConfig {
    private static final Translator translator = new Translator("rule.welcomeMessage");
    private static final CustomWelcomeMessageConfig CONFIG = new CustomWelcomeMessageConfig();

    private CustomWelcomeMessageConfig() {
    }

    public static CustomWelcomeMessageConfig getConfig() {
        return CONFIG;
    }

    private static void handleMessage(class_1657 player, MinecraftServer server) {
        try {
            JsonObject config;
            Path path = server.method_27050(class_5218.field_24188).resolve("carpetamsaddition/welcomeMessage.json");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                JsonObject defaultConfig = new JsonObject();
                JsonArray defaultMsg = new JsonArray();
                defaultMsg.add("\u00a73\u00a7o " + translator.tr("modify_content_in", new Object[0]).getString());
                defaultMsg.add("\u00a7a" + translator.tr("save_path", new Object[0]).getString() + "/carpetamsaddition/welcomeMessage.json");
                defaultConfig.add("welcomeMessage", (JsonElement)defaultMsg);
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toFile()), StandardCharsets.UTF_8);){
                    new Gson().toJson((JsonElement)defaultConfig, (Appendable)writer);
                }
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), StandardCharsets.UTF_8);){
                config = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            JsonElement msgElement = config.get("welcomeMessage");
            if (msgElement.isJsonArray()) {
                JsonArray messages = msgElement.getAsJsonArray();
                for (JsonElement element : messages) {
                    String line = element.getAsString();
                    player.method_7353((class_2561)Messenger.s(line), false);
                }
            } else {
                String legacyMsg = msgElement.getAsString();
                for (String line : legacyMsg.split("\n")) {
                    player.method_7353((class_2561)Messenger.s(line.trim()), false);
                }
            }
        }
        catch (Exception e) {
            AmsServer.LOGGER.error("An error occurred while processing the welcome message configuration", (Throwable)e);
        }
    }

    public void sendWelcomeMessage(class_1657 player, MinecraftServer server) {
        if (AmsServerSettings.welcomeMessage) {
            CustomWelcomeMessageConfig.handleMessage(player, server);
        }
    }
}

