/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandSetPlayerPose;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.commands.suggestionProviders.ListSuggestionProvider;
import club.mcams.carpet.network.payloads.rule.commandSetPlayerPose.UpdatePlayerPosePayload_S2C;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.NetworkUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SetPlayerPoseCommandRegistry {
    private static final Translator tr = new Translator("command.playerPose");
    private static final List<String> POSE = Arrays.asList("spin_attack", "swimming", "sleeping", "fall_flying", "standing", "crouching", "dying");
    public static final Map<UUID, String> DO_POSE_MAP = new ConcurrentHashMap<UUID, String>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"playerPose").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandSetPlayerPose))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"pose", (ArgumentType)StringArgumentType.greedyString()).suggests(ListSuggestionProvider.of(POSE)).executes(ctx -> SetPlayerPoseCommandRegistry.set(class_2186.method_9315((CommandContext)ctx, (String)"player"), ((class_2168)ctx.getSource()).method_9211(), StringArgumentType.getString((CommandContext)ctx, (String)"pose"))))))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"stop").executes(ctx -> SetPlayerPoseCommandRegistry.stop(class_2186.method_9315((CommandContext)ctx, (String)"player"), ((class_2168)ctx.getSource()).method_9211()))))).then(class_2170.method_9247((String)"help").executes(ctx -> SetPlayerPoseCommandRegistry.help((class_2168)ctx.getSource()))));
    }

    private static int set(class_3222 targetPlayer, MinecraftServer server, String pose) {
        DO_POSE_MAP.put(targetPlayer.method_5667(), pose);
        targetPlayer.method_5660(true);
        SetPlayerPoseCommandRegistry.triggerPoseUpdate(targetPlayer);
        SetPlayerPoseCommandRegistry.broadcastSyncDatapack(targetPlayer, server);
        return 1;
    }

    private static int stop(class_3222 targetPlayer, MinecraftServer server) {
        DO_POSE_MAP.remove(targetPlayer.method_5667());
        SetPlayerPoseCommandRegistry.triggerPoseUpdate(targetPlayer);
        SetPlayerPoseCommandRegistry.broadcastSyncDatapack(targetPlayer, server);
        return 1;
    }

    private static int help(class_2168 source) {
        Messenger.tell(source, Messenger.formatting((class_2554)tr.tr("set_help", new Object[0]).method_10852(Messenger.endl()).method_10852((class_2561)tr.tr("stop_help", new Object[0])), class_124.field_1080));
        return 1;
    }

    private static void broadcastSyncDatapack(class_3222 targetPlayer, MinecraftServer server) {
        NetworkUtil.broadcastDataPack(server, UpdatePlayerPosePayload_S2C.create(DO_POSE_MAP, targetPlayer.method_5667()));
    }

    private static void triggerPoseUpdate(class_3222 targetPlayer) {
        targetPlayer.method_5660(true);
        Runnable stopSneaking = () -> targetPlayer.method_5660(false);
        Runnable stopSneakingOnServerThread = () -> NetworkUtil.executeOnServerThread(stopSneaking);
        CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(stopSneakingOnServerThread);
    }
}

