/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.utils;

import club.mcams.carpet.network.AMS_CustomPayload;
import club.mcams.carpet.utils.MinecraftClientUtil;
import club.mcams.carpet.utils.MinecraftServerUtil;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;

public class NetworkUtil {
    private static final Set<UUID> SUPPORT_CLIENT = ConcurrentHashMap.newKeySet();
    private static final AtomicBoolean SUPPORT_SERVER = new AtomicBoolean(false);

    public static void broadcastDataPack(MinecraftServer server, AMS_CustomPayload payload) {
        server.method_3760().method_14571().forEach(player -> NetworkUtil.sendS2CPacketIfSupport(player, payload));
    }

    public static void forcedBroadcastDataPack(MinecraftServer server, AMS_CustomPayload payload) {
        server.method_3760().method_14571().forEach(payload::sendS2CPacket);
    }

    public static void sendS2CPacketIfSupport(class_3222 player, AMS_CustomPayload payload) {
        if (NetworkUtil.isSupportClient(player.method_5667())) {
            payload.sendS2CPacket(player);
        }
    }

    public static void sendC2SPacketIfSupport(class_746 player, AMS_CustomPayload payload) {
        if (NetworkUtil.isSupportServer()) {
            payload.sendC2SPacket(player);
        }
    }

    public static void sendS2CPacket(class_3222 player, AMS_CustomPayload payload) {
        payload.sendS2CPacket(player);
    }

    public static void sendC2SPacket(class_746 player, AMS_CustomPayload payload) {
        payload.sendC2SPacket(player);
    }

    public static boolean isSupportClient(UUID uuid) {
        return SUPPORT_CLIENT.contains(uuid);
    }

    public static boolean isSupportServer() {
        return SUPPORT_SERVER.get();
    }

    public static void setServerSupport(boolean support) {
        SUPPORT_SERVER.set(support);
    }

    public static Boolean getServerSupport() {
        return SUPPORT_SERVER.get();
    }

    public static Set<UUID> getSupportClientSet() {
        return SUPPORT_CLIENT;
    }

    public static void addSupportClient(UUID uuid) {
        SUPPORT_CLIENT.add(uuid);
    }

    public static void removeSupportClient(UUID uuid) {
        SUPPORT_CLIENT.remove(uuid);
    }

    public static void clearClientSupport() {
        SUPPORT_CLIENT.clear();
    }

    public static void executeOnClientThread(Runnable runnable) {
        if (MinecraftClientUtil.clientIsRunning()) {
            MinecraftClientUtil.getCurrentClient().execute(runnable);
        }
    }

    public static void executeOnServerThread(Runnable runnable) {
        if (MinecraftServerUtil.serverIsRunning()) {
            MinecraftServerUtil.getServer().execute(runnable);
        }
    }

    public static String readBufString(class_2540 buf) {
        return buf.method_19772();
    }
}

