/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.api.recipe;

import club.mcams.carpet.api.recipe.AmsRecipeBuilder;
import club.mcams.carpet.api.recipe.template.ShapedRecipeTemplate;
import club.mcams.carpet.api.recipe.template.ShapelessRecipeTemplate;
import club.mcams.carpet.api.recipe.template.SmeltingRecipeTemplate;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class AmsRecipeManager {
    private final List<ShapelessRecipeTemplate> shapelessRecipes;
    private final List<ShapedRecipeTemplate> shapedRecipes;
    private final List<SmeltingRecipeTemplate> smeltingRecipes;

    public AmsRecipeManager(AmsRecipeBuilder builder) {
        this.shapelessRecipes = builder.getShapelessRecipeList();
        this.shapedRecipes = builder.getShapedRecipeList();
        this.smeltingRecipes = builder.getSmeltingRecipeList();
    }

    public void registerRecipes(Map<class_2960, JsonElement> recipeMap) {
        this.registerAllRecipes(recipeMap);
    }

    private void registerAllRecipes(Map<class_2960, JsonElement> recipeMap) {
        this.shapelessRecipes.forEach(recipe -> recipe.addToRecipeMap(recipeMap));
        this.shapedRecipes.forEach(recipe -> recipe.addToRecipeMap(recipeMap));
        this.smeltingRecipes.forEach(recipe -> recipe.addToRecipeMap(recipeMap));
    }

    public static void clearRecipeListMemory(AmsRecipeBuilder amsRecipeBuilder) {
        amsRecipeBuilder.getShapedRecipeList().clear();
        amsRecipeBuilder.getShapelessRecipeList().clear();
        amsRecipeBuilder.getSmeltingRecipeList().clear();
    }
}

