/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.debug.network;

import club.mcams.carpet.AmsServerMod;
import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.network.payloads.debug.RequestClientModVersionPayload_S2C;
import club.mcams.carpet.network.payloads.handshake.RequestHandShakeS2CPayload;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.MinecraftServerUtil;
import club.mcams.carpet.utils.NetworkUtil;
import club.mcams.carpet.utils.PlayerUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2554;
import net.minecraft.class_3222;

public class AmspCommandRegistry {
    private static final Translator tr = new Translator("command.amsp");
    public static final Map<UUID, String> clientModVersion = new ConcurrentHashMap<UUID, String>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"amsp").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandAmspDebug))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"show").then(class_2170.method_9247((String)"supportClientList").executes(ctx -> AmspCommandRegistry.showSupportClientList((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"serverSupportStatus").executes(ctx -> AmspCommandRegistry.showServerSupportStatus((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"clientModVersion").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> AmspCommandRegistry.showClientModVersion((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(class_2170.method_9247((String)"serverModVersion").executes(ctx -> AmspCommandRegistry.showServerModVersion((class_2168)ctx.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deny").then(class_2170.method_9247((String)"clientConnection").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> AmspCommandRegistry.denyClientConnection((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(class_2170.method_9247((String)"all").executes(ctx -> AmspCommandRegistry.denyAllClientConnections((class_2168)ctx.getSource()))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"serverSupport").then(class_2170.method_9244((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> AmspCommandRegistry.setServerSupport((class_2168)ctx.getSource(), BoolArgumentType.getBool((CommandContext)ctx, (String)"boolean"))))))).then(class_2170.method_9247((String)"request").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"handshake").executes(ctx -> AmspCommandRegistry.requestHandShake((class_2168)ctx.getSource()))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(ctx -> AmspCommandRegistry.requestHandShake((class_2168)ctx.getSource(), class_2186.method_9312((CommandContext)ctx, (String)"players")))))));
    }

    private static int showSupportClientList(class_2168 source) {
        Iterator<UUID> iterator = NetworkUtil.getSupportClientSet().iterator();
        if (!iterator.hasNext()) {
            Messenger.tell(source, Messenger.formatting(tr.tr("support_client_set_is_none", new Object[0]), class_124.field_1054));
            return 0;
        }
        Messenger.tell(source, Messenger.formatting(tr.tr("support_client_list_title", new Object[0]), class_124.field_1075));
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            String strUuid = uuid.toString();
            String playerName = PlayerUtil.getName(uuid);
            class_2554 text = Messenger.formatting(Messenger.s(strUuid + " - " + playerName), class_124.field_1075);
            Messenger.tell(source, text);
        }
        return 1;
    }

    private static int showServerSupportStatus(class_2168 source) {
        class_124 formatting = NetworkUtil.getServerSupport() != false ? class_124.field_1060 : class_124.field_1061;
        Messenger.tell(source, Messenger.formatting(tr.tr("server_support_status", String.valueOf(NetworkUtil.getServerSupport())), formatting));
        return 1;
    }

    private static int showClientModVersion(final class_2168 source, final class_3222 targetPlayer) {
        final UUID playerUuid = targetPlayer.method_5667();
        clientModVersion.clear();
        NetworkUtil.sendS2CPacketIfSupport(targetPlayer, RequestClientModVersionPayload_S2C.create(playerUuid));
        final int[] retryCount = new int[]{0};
        int maxRetries = 5;
        Runnable checkAndRetry = new Runnable(){

            @Override
            public void run() {
                NetworkUtil.executeOnServerThread(() -> {
                    String version = clientModVersion.get(playerUuid);
                    if (version != null) {
                        Messenger.tell(source, Messenger.formatting(tr.tr("client_mod_version_success_feedback", PlayerUtil.getName((class_1657)targetPlayer), version), class_124.field_1075));
                        clientModVersion.remove(playerUuid);
                    } else if (retryCount[0] < 5) {
                        retryCount2[0] = retryCount[0] + 1;
                        Messenger.tell(source, Messenger.formatting(tr.tr("request_client_version", String.valueOf(retryCount[0])), class_124.field_1054));
                        NetworkUtil.sendS2CPacketIfSupport(targetPlayer, RequestClientModVersionPayload_S2C.create(playerUuid));
                        CompletableFuture.delayedExecutor(3L, TimeUnit.SECONDS).execute(this);
                    } else {
                        Messenger.tell(source, Messenger.formatting(tr.tr("client_mod_version_failed_feedback", String.valueOf(5)), class_124.field_1061));
                    }
                });
            }
        };
        CompletableFuture.delayedExecutor(3L, TimeUnit.SECONDS).execute(checkAndRetry);
        Messenger.tell(source, Messenger.formatting(tr.tr("get_client_version_waiting", new Object[0]), class_124.field_1060));
        return 1;
    }

    private static int showServerModVersion(class_2168 source) {
        Messenger.tell(source, Messenger.formatting(tr.tr("server_mod_version_feedback", "Carpet AMS Addition", AmsServerMod.getVersion()), class_124.field_1075));
        return 1;
    }

    private static int denyClientConnection(class_2168 source, class_3222 targetPlayer) {
        NetworkUtil.removeSupportClient(targetPlayer.method_5667());
        Messenger.tell(source, Messenger.formatting(tr.tr("deny_client_feedback", PlayerUtil.getName(targetPlayer.method_5667())), class_124.field_1076));
        return 1;
    }

    private static int denyAllClientConnections(class_2168 source) {
        NetworkUtil.clearClientSupport();
        Messenger.tell(source, Messenger.formatting(tr.tr("deny_all_client_feedback", new Object[0]), class_124.field_1076));
        return 1;
    }

    private static int setServerSupport(class_2168 source, Boolean support) {
        NetworkUtil.setServerSupport(support);
        Messenger.tell(source, Messenger.formatting(tr.tr("set_server_support_feedback", String.valueOf(NetworkUtil.getServerSupport())), class_124.field_1060));
        return 1;
    }

    private static int requestHandShake(class_2168 source) {
        return AmspCommandRegistry.requestHandShake(source, MinecraftServerUtil.getOnlinePlayers());
    }

    private static int requestHandShake(class_2168 source, Collection<class_3222> players) {
        for (class_3222 player : players) {
            NetworkUtil.sendS2CPacket(player, RequestHandShakeS2CPayload.create());
            Messenger.tell(source, Messenger.formatting(tr.tr("request_handshake_feedback", PlayerUtil.getName((class_1657)player)), class_124.field_1060));
        }
        return 1;
    }
}

