/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.network;

import club.mcams.carpet.network.AMS_CustomPayload;
import club.mcams.carpet.network.AMS_PayloadCodec;
import club.mcams.carpet.network.PayloadHandlerChain;
import club.mcams.carpet.network.payloads.AMS_UnknownPayload;
import club.mcams.carpet.network.payloads.debug.RequestClientModVersionPayload_C2S;
import club.mcams.carpet.network.payloads.debug.RequestClientModVersionPayload_S2C;
import club.mcams.carpet.network.payloads.handshake.HandShakeC2SPayload;
import club.mcams.carpet.network.payloads.handshake.HandShakeS2CPayload;
import club.mcams.carpet.network.payloads.handshake.RequestHandShakeS2CPayload;
import club.mcams.carpet.network.payloads.rule.commandCustomBlockHardness.CustomBlockHardnessPayload_S2C;
import club.mcams.carpet.network.payloads.rule.commandGetClientPlayerFPS.ClientPlayerFpsPayload_C2S;
import club.mcams.carpet.network.payloads.rule.commandGetClientPlayerFPS.ClientPlayerFpsPayload_S2C;
import club.mcams.carpet.network.payloads.rule.commandSetPlayerPose.UpdatePlayerPosePayload_S2C;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2658;
import net.minecraft.class_2817;

public class AMS_PayloadManager {
    protected static final Map<String, Function<class_2540, AMS_CustomPayload>> PAYLOAD_REGISTRY = new ConcurrentHashMap<String, Function<class_2540, AMS_CustomPayload>>();
    private static final PayloadHandlerChain C2S_HANDLER_CHAIN = PayloadHandlerChainCreator.createC2SHandlerChain();
    private static final PayloadHandlerChain S2C_HANDLER_CHAIN = PayloadHandlerChainCreator.createS2CHandlerChain();

    private static void registerC2SHandlers(PayloadHandlerChain chain) {
        chain.addHandlerFor(HandShakeC2SPayload.class, HandShakeC2SPayload::handle);
        chain.addHandlerFor(AMS_UnknownPayload.class, AMS_UnknownPayload::handle);
        chain.addHandlerFor(ClientPlayerFpsPayload_C2S.class, ClientPlayerFpsPayload_C2S::handle);
        chain.addHandlerFor(RequestClientModVersionPayload_C2S.class, RequestClientModVersionPayload_C2S::handle);
    }

    private static void registerS2CHandlers(PayloadHandlerChain chain) {
        chain.addHandlerFor(HandShakeS2CPayload.class, HandShakeS2CPayload::handle);
        chain.addHandlerFor(RequestHandShakeS2CPayload.class, RequestHandShakeS2CPayload::handle);
        chain.addHandlerFor(CustomBlockHardnessPayload_S2C.class, CustomBlockHardnessPayload_S2C::handle);
        chain.addHandlerFor(AMS_UnknownPayload.class, AMS_UnknownPayload::handle);
        chain.addHandlerFor(ClientPlayerFpsPayload_S2C.class, ClientPlayerFpsPayload_S2C::handle);
        chain.addHandlerFor(UpdatePlayerPosePayload_S2C.class, UpdatePlayerPosePayload_S2C::handle);
        chain.addHandlerFor(RequestClientModVersionPayload_S2C.class, RequestClientModVersionPayload_S2C::handle);
    }

    public static void registerC2SPayloads() {
        HandShakeC2SPayload.register();
        AMS_UnknownPayload.register();
        ClientPlayerFpsPayload_C2S.register();
        RequestClientModVersionPayload_C2S.register();
    }

    public static void registerS2CPayloads() {
        HandShakeS2CPayload.register();
        RequestHandShakeS2CPayload.register();
        CustomBlockHardnessPayload_S2C.register();
        AMS_UnknownPayload.register();
        ClientPlayerFpsPayload_S2C.register();
        UpdatePlayerPosePayload_S2C.register();
        RequestClientModVersionPayload_S2C.register();
    }

    public static AMS_CustomPayload C2S_decodePacket(class_2817 packet) {
        return AMS_PayloadCodec.decode(packet);
    }

    public static AMS_CustomPayload S2C_decodePacket(class_2658 packet) {
        return AMS_PayloadCodec.decode(packet);
    }

    public static void register(String packetId, Function<class_2540, AMS_CustomPayload> constructor) {
        PAYLOAD_REGISTRY.put(packetId, constructor);
    }

    private static class PayloadHandlerChainCreator {
        private PayloadHandlerChainCreator() {
        }

        private static PayloadHandlerChain createC2SHandlerChain() {
            PayloadHandlerChain chain = new PayloadHandlerChain();
            AMS_PayloadManager.registerC2SHandlers(chain);
            return chain;
        }

        private static PayloadHandlerChain createS2CHandlerChain() {
            PayloadHandlerChain chain = new PayloadHandlerChain();
            AMS_PayloadManager.registerS2CHandlers(chain);
            return chain;
        }
    }

    public static class HandlerChainGetter {
        public static PayloadHandlerChain getC2SHandlerChain() {
            return C2S_HANDLER_CHAIN;
        }

        public static PayloadHandlerChain getS2CHandlerChain() {
            return S2C_HANDLER_CHAIN;
        }
    }

    public static enum PacketId {
        UNKNOWN("unknown"),
        HANDSHAKE_C2S("handshake_c2s"),
        HANDSHAKE_S2C("handshake_s2c"),
        REQUEST_CLIENT_MOD_VERSION_S2C("request_client_mod_version_s2c"),
        REQUEST_CLIENT_MOD_VERSION_C2S("request_client_mod_version_c2s"),
        REQUEST_HANDSHAKE_S2C("request_handshake_s2c"),
        SYNC_CUSTOM_BLOCK_HARDNESS("sync_custom_block_hardness"),
        CLIENT_PLAYER_FPS_C2S("client_player_fps_c2s"),
        CLIENT_PLAYER_FPS_S2C("client_player_fps_s2c"),
        UPDATE_PLAYER_POSE_S2C("update_player_pose_s2c");

        private final String id;

        private PacketId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

