/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.settings;

import carpet.settings.Condition;
import carpet.settings.ParsedRule;
import carpet.settings.SettingsManager;
import carpet.settings.Validator;
import club.mcams.carpet.AmsServer;
import club.mcams.carpet.mixin.setting.ParsedRuleAccessor;
import club.mcams.carpet.mixin.setting.SettingsManagerAccessor;
import club.mcams.carpet.settings.Rule;
import club.mcams.carpet.translations.AMSTranslations;
import club.mcams.carpet.translations.TranslationConstants;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CarpetRuleRegistrar {
    private final SettingsManager settingsManager;
    private final List<ParsedRule<?>> rules = Lists.newArrayList();

    private CarpetRuleRegistrar(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public static void register(SettingsManager settingsManager, Class<?> settingsClass) {
        CarpetRuleRegistrar registrar = new CarpetRuleRegistrar(settingsManager);
        registrar.parseSettingsClass(settingsClass);
        registrar.registerToCarpet();
    }

    private void parseSettingsClass(Class<?> settingsClass) {
        for (Field field : settingsClass.getDeclaredFields()) {
            Rule rule = field.getAnnotation(Rule.class);
            if (rule == null) continue;
            this.parseRule(field, rule);
        }
    }

    private void parseRule(final Field field, final Rule rule) {
        carpet.settings.Rule cmRule = new carpet.settings.Rule(){
            private final String basedKey = TranslationConstants.CARPET_TRANSLATIONS_KEY_PREFIX + "rule." + this.name() + ".";

            @Nullable
            private String tr(String key) {
                return AMSTranslations.translateKeyToFormattedString("en_us", this.basedKey + key);
            }

            public String desc() {
                String desc = this.tr("desc");
                if (desc == null) {
                    throw new NullPointerException(String.format("Rule %s has no translated desc", this.name()));
                }
                return desc;
            }

            public String[] extra() {
                String message;
                ArrayList extraMessages = Lists.newArrayList();
                int i = 0;
                while ((message = this.tr("extra." + i)) != null) {
                    extraMessages.add(message);
                    ++i;
                }
                return extraMessages.toArray(new String[0]);
            }

            public String name() {
                return field.getName();
            }

            public String[] category() {
                return rule.categories();
            }

            public String[] options() {
                return rule.options();
            }

            public boolean strict() {
                return rule.strict();
            }

            public Class<? extends Validator>[] validate() {
                return rule.validators();
            }

            public Class<? extends Annotation> annotationType() {
                return rule.annotationType();
            }

            public String appSource() {
                return "";
            }

            public Class<? extends Condition>[] condition() {
                return new Class[0];
            }
        };
        ParsedRule parsedRule = ParsedRuleAccessor.invokeConstructor(field, cmRule, this.settingsManager);
        this.rules.add(parsedRule);
    }

    private void registerToCarpet() {
        for (ParsedRule<?> rule : this.rules) {
            ParsedRule<?> existingRule = ((SettingsManagerAccessor)this.settingsManager).getRules$AMS().put(rule.name, rule);
            if (existingRule == null) continue;
            AmsServer.LOGGER.warn("Overwriting existing rule {}", existingRule);
        }
    }
}

