/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandCustomAntiFireItems;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.config.rule.commandAntiFireItems.CustomAntiFireItemsConfig;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.RegexTools;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class CustomAntiFireItemsCommandRegistry {
    private static final Translator translator = new Translator("command.customAntiFireItems");
    private static final String MSG_HEAD = "<customAntiFireItems> ";
    public static final List<String> CUSTOM_ANTI_FIRE_ITEMS = new ArrayList<String>();

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"customAntiFireItems").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandCustomAntiFireItems))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandRegistryAccess)).executes(context -> CustomAntiFireItemsCommandRegistry.add((class_1657)((class_2168)context.getSource()).method_9207(), class_2287.method_9777((CommandContext)context, (String)"item").method_9781(1, false)))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandRegistryAccess)).executes(context -> CustomAntiFireItemsCommandRegistry.remove((class_1657)((class_2168)context.getSource()).method_9207(), class_2287.method_9777((CommandContext)context, (String)"item").method_9781(1, false)))))).then(class_2170.method_9247((String)"removeAll").executes(context -> CustomAntiFireItemsCommandRegistry.removeAll((class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"list").executes(context -> CustomAntiFireItemsCommandRegistry.list(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"help").executes(context -> CustomAntiFireItemsCommandRegistry.help(((class_2168)context.getSource()).method_9207()))));
    }

    private static int add(class_1657 player, class_1799 itemStack) {
        if (!CUSTOM_ANTI_FIRE_ITEMS.contains(CustomAntiFireItemsCommandRegistry.getItemName(itemStack))) {
            CUSTOM_ANTI_FIRE_ITEMS.add(CustomAntiFireItemsCommandRegistry.getItemName(itemStack));
            CustomAntiFireItemsCommandRegistry.saveToJson();
            player.method_7353((class_2561)Messenger.s("<customAntiFireItems> + " + CustomAntiFireItemsCommandRegistry.getItemName(itemStack)).method_27692(class_124.field_1060), false);
        } else {
            player.method_7353((class_2561)Messenger.s(MSG_HEAD + CustomAntiFireItemsCommandRegistry.getItemName(itemStack) + translator.tr("already_exists", new Object[0]).getString()).method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    private static int remove(class_1657 player, class_1799 itemStack) {
        if (CUSTOM_ANTI_FIRE_ITEMS.contains(CustomAntiFireItemsCommandRegistry.getItemName(itemStack))) {
            CUSTOM_ANTI_FIRE_ITEMS.remove(CustomAntiFireItemsCommandRegistry.getItemName(itemStack));
            CustomAntiFireItemsCommandRegistry.saveToJson();
            player.method_7353((class_2561)Messenger.s("<customAntiFireItems> - " + CustomAntiFireItemsCommandRegistry.getItemName(itemStack)).method_27692(class_124.field_1061), false);
        } else {
            player.method_7353((class_2561)Messenger.s(MSG_HEAD + CustomAntiFireItemsCommandRegistry.getItemName(itemStack) + translator.tr("not_found", new Object[0]).getString()).method_27692(class_124.field_1061), false);
        }
        return 1;
    }

    private static int removeAll(class_1657 player) {
        CUSTOM_ANTI_FIRE_ITEMS.clear();
        CustomAntiFireItemsCommandRegistry.saveToJson();
        player.method_7353((class_2561)Messenger.s(MSG_HEAD + translator.tr("removeAll", new Object[0]).getString()).method_27692(class_124.field_1061), false);
        return 1;
    }

    private static int list(class_3222 player) {
        player.method_7353((class_2561)Messenger.s(translator.tr("list", new Object[0]).getString() + "\n-------------------------------").method_27692(class_124.field_1060), false);
        for (String blockName : CUSTOM_ANTI_FIRE_ITEMS) {
            player.method_7353((class_2561)Messenger.s(blockName).method_27692(class_124.field_1060), false);
        }
        return 1;
    }

    private static int help(class_3222 player) {
        String setHelpText = translator.tr("help.set", new Object[0]).getString();
        String removeHelpText = translator.tr("help.remove", new Object[0]).getString();
        String removeAllHelpText = translator.tr("help.removeAll", new Object[0]).getString();
        String listHelpText = translator.tr("help.list", new Object[0]).getString();
        player.method_7353((class_2561)Messenger.s("\n" + setHelpText + "\n" + removeHelpText + "\n" + removeAllHelpText + "\n" + listHelpText).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)), false);
        return 1;
    }

    private static void saveToJson() {
        CustomAntiFireItemsConfig.getInstance().saveToJson(CUSTOM_ANTI_FIRE_ITEMS);
    }

    private static String getItemName(class_1799 stack) {
        return RegexTools.getItemRegisterName(stack);
    }
}

